/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.cp.internal.CPSubsystemEnterpriseImpl;
import com.hazelcast.client.cp.internal.datastructures.proxy.ClientRaftProxyEnterpriseFactory;
import com.hazelcast.client.cp.internal.session.ClientProxySessionManager;
import com.hazelcast.client.impl.clientside.ClientTLSChannelInitializer;
import com.hazelcast.client.impl.clientside.DefaultClientExtension;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientManagedContext;
import com.hazelcast.client.impl.spi.ClientCPGroupViewServiceImpl;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.EnterpriseClientClusterServiceImpl;
import com.hazelcast.client.impl.spi.impl.listener.ClientCPGroupViewService;
import com.hazelcast.client.impl.spi.impl.listener.NoOpClientCPGroupViewService;
import com.hazelcast.config.InstanceTrackingConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.internal.session.ProxySessionManager;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.memory.FreeMemoryChecker;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.memory.PoolingMemoryManager;
import com.hazelcast.internal.memory.StandardMemoryManager;
import com.hazelcast.internal.memory.impl.LibMallocFactory;
import com.hazelcast.internal.memory.impl.MemkindMallocFactory;
import com.hazelcast.internal.memory.impl.MemkindUtil;
import com.hazelcast.internal.memory.impl.UnsafeMallocFactory;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.StaticMetricsProvider;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.EnterpriseNearCacheManager;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.ClusterVersionAware;
import com.hazelcast.internal.serialization.impl.EnterpriseSerializationServiceBuilder;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.memory.Capacity;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.version.Version;
import java.util.Map;
import java.util.concurrent.Executor;

public class EnterpriseClientExtension
extends DefaultClientExtension
implements StaticMetricsProvider {
    private final BuildInfo buildInfo = BuildInfoProvider.getBuildInfo();
    private final EnterpriseClientVersionAware versionAware = new EnterpriseClientVersionAware(this.buildInfo.getVersion());
    private HazelcastMemoryManager memoryManager;

    @Override
    public void beforeStart(HazelcastClientInstanceImpl client) {
        super.beforeStart(client);
    }

    @Override
    protected Map<String, Object> getTrackingFileProperties(BuildInfo buildInfo) {
        Map<String, Object> properties = super.getTrackingFileProperties(buildInfo);
        properties.put(InstanceTrackingConfig.InstanceTrackingProperties.PRODUCT.getPropertyName(), InstanceTrackingConfig.InstanceProductName.HAZELCAST_CLIENT_EE.getProductName());
        return properties;
    }

    @Override
    public InternalSerializationService createSerializationService(byte version) {
        InternalSerializationService ss;
        try {
            ClientConfig config = this.client.getClientConfig();
            ClassLoader configClassLoader = config.getClassLoader();
            PartitioningStrategy partitioningStrategy = this.getPartitioningStrategy(configClassLoader);
            EnterpriseSerializationServiceBuilder builder = new EnterpriseSerializationServiceBuilder();
            SerializationConfig serializationConfig = config.getSerializationConfig() != null ? config.getSerializationConfig() : new SerializationConfig();
            this.memoryManager = this.getMemoryManager(this.client);
            ss = (InternalSerializationService)builder.setMemoryManager(this.memoryManager).setClassLoader(configClassLoader).setConfig(serializationConfig).setManagedContext(new HazelcastClientManagedContext(this.client, config.getManagedContext())).setPartitioningStrategy(partitioningStrategy).setHazelcastInstance(this.client).setClusterVersionAware(this.versionAware).setVersionedSerializationEnabled(false).setSchemaService(this.client.getSchemaService()).setNotActiveExceptionSupplier(() -> new HazelcastClientNotActiveException("Client is shutdown")).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return ss;
    }

    private HazelcastMemoryManager getMemoryManager(HazelcastClientInstanceImpl client) {
        NativeMemoryConfig memoryConfig = client.getClientConfig().getNativeMemoryConfig();
        if (memoryConfig.isEnabled()) {
            Capacity size = memoryConfig.getCapacity();
            NativeMemoryConfig.MemoryAllocatorType type = memoryConfig.getAllocatorType();
            FreeMemoryChecker freeMemoryChecker = new FreeMemoryChecker(client.getProperties());
            LibMallocFactory libMallocFactory = !MemkindUtil.shouldUseMemkindMalloc(memoryConfig) ? new UnsafeMallocFactory(freeMemoryChecker) : new MemkindMallocFactory(memoryConfig);
            LOGGER.info("Creating " + String.valueOf((Object)type) + " native memory manager with " + size.toPrettyString() + " size");
            if (type == NativeMemoryConfig.MemoryAllocatorType.STANDARD) {
                return new StandardMemoryManager(size, libMallocFactory);
            }
            int blockSize = memoryConfig.getMinBlockSize();
            int pageSize = memoryConfig.getPageSize();
            float metadataSpace = memoryConfig.getMetadataSpacePercentage();
            return new PoolingMemoryManager(size, blockSize, pageSize, metadataSpace, libMallocFactory, client.getName());
        }
        return null;
    }

    @Override
    public ChannelInitializer createChannelInitializer() {
        ClientNetworkConfig networkConfig = this.client.getClientConfig().getNetworkConfig();
        SSLConfig sslConfig = networkConfig.getSSLConfig();
        return this.createChannelInitializer(sslConfig, networkConfig.getSocketOptions());
    }

    @Override
    public ChannelInitializer createChannelInitializer(SSLConfig sslConfig, SocketOptions socketOptions) {
        if (sslConfig != null && sslConfig.isEnabled()) {
            LOGGER.info("SSL is enabled");
            Executor executor = ConcurrencyUtil.getDefaultAsyncExecutor();
            return new ClientTLSChannelInitializer(sslConfig, executor, socketOptions);
        }
        return super.createChannelInitializer(sslConfig, socketOptions);
    }

    @Override
    public SocketInterceptor createSocketInterceptor() {
        ClientNetworkConfig networkConfig = this.client.getClientConfig().getNetworkConfig();
        return this.createSocketInterceptor(networkConfig.getSocketInterceptorConfig());
    }

    @Override
    public SocketInterceptor createSocketInterceptor(SocketInterceptorConfig sic) {
        SocketInterceptor implementation = null;
        if (sic != null && sic.isEnabled() && (implementation = (SocketInterceptor)sic.getImplementation()) == null && sic.getClassName() != null) {
            try {
                implementation = (SocketInterceptor)Class.forName(sic.getClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                LOGGER.severe("SocketInterceptor class cannot be instantiated!" + sic.getClassName(), e);
            }
        }
        if (implementation != null) {
            implementation.init(sic.getProperties());
        }
        return implementation;
    }

    @Override
    public NearCacheManager createNearCacheManager() {
        InternalSerializationService ss = this.client.getSerializationService();
        TaskScheduler taskScheduler = this.client.getTaskScheduler();
        ClassLoader classLoader = this.client.getClientConfig().getClassLoader();
        HazelcastProperties properties = this.client.getProperties();
        return new EnterpriseNearCacheManager((EnterpriseSerializationService)ss, taskScheduler, classLoader, properties);
    }

    @Override
    public void provideStaticMetrics(MetricsRegistry registry) {
        if (this.memoryManager != null) {
            registry.registerStaticMetrics(this.memoryManager, "memorymanager");
            HazelcastMemoryManager hazelcastMemoryManager = this.memoryManager;
            if (hazelcastMemoryManager instanceof StaticMetricsProvider) {
                StaticMetricsProvider provider = (StaticMetricsProvider)((Object)hazelcastMemoryManager);
                provider.provideStaticMetrics(registry);
            }
        }
    }

    @Override
    public MemoryStats getMemoryStats() {
        HazelcastMemoryManager mm = this.memoryManager;
        return mm != null ? mm.getMemoryStats() : super.getMemoryStats();
    }

    @Override
    public CPSubsystem createCPSubsystem(HazelcastClientInstanceImpl hazelcastClientInstance) {
        return new CPSubsystemEnterpriseImpl(new ClientRaftProxyEnterpriseFactory(hazelcastClientInstance));
    }

    @Override
    public ProxySessionManager createProxySessionManager(HazelcastClientInstanceImpl hazelcastClientInstance) {
        return new ClientProxySessionManager(hazelcastClientInstance);
    }

    @Override
    public ClientClusterService createClientClusterService(HazelcastClientInstanceImpl clientInstance) {
        return new EnterpriseClientClusterServiceImpl(clientInstance);
    }

    @Override
    public ClientCPGroupViewService createClientCPGroupViewService(HazelcastClientInstanceImpl hazelcastClientInstance, boolean directToLeaderRoutingEnabled) {
        return directToLeaderRoutingEnabled ? new ClientCPGroupViewServiceImpl(hazelcastClientInstance) : new NoOpClientCPGroupViewService();
    }

    private static class EnterpriseClientVersionAware
    implements ClusterVersionAware {
        private final Version version;

        EnterpriseClientVersionAware(String buildVersion) {
            this.version = Version.of(buildVersion);
        }

        @Override
        public Version getClusterVersion() {
            return this.version;
        }
    }
}

