/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.session;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPSessionCloseSessionCodec;
import com.hazelcast.client.impl.protocol.codec.CPSessionCreateSessionCodec;
import com.hazelcast.client.impl.protocol.codec.CPSessionGenerateThreadIdCodec;
import com.hazelcast.client.impl.protocol.codec.CPSessionHeartbeatSessionCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.session.AbstractProxySessionManager;
import com.hazelcast.cp.internal.session.SessionResponse;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ClientProxySessionManager
extends AbstractProxySessionManager {
    private static final long SHUTDOWN_TIMEOUT_SECONDS = 60L;
    private static final long SHUTDOWN_WAIT_SLEEP_MILLIS = 10L;
    private final HazelcastClientInstanceImpl client;

    public ClientProxySessionManager(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    @Override
    protected long generateThreadId(RaftGroupId groupId) {
        ClientMessage request = CPSessionGenerateThreadIdCodec.encodeRequest(groupId);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.client, request, "sessionManager").invoke().joinInternal();
        return CPSessionGenerateThreadIdCodec.decodeResponse(response);
    }

    @Override
    protected SessionResponse requestNewSession(RaftGroupId groupId) {
        ClientMessage request = CPSessionCreateSessionCodec.encodeRequest(groupId, this.client.getName());
        ClientMessage response = (ClientMessage)new ClientInvocation(this.client, request, "sessionManager").invoke().joinInternal();
        CPSessionCreateSessionCodec.ResponseParameters params = CPSessionCreateSessionCodec.decodeResponse(response);
        return new SessionResponse(params.sessionId, params.ttlMillis, params.heartbeatMillis);
    }

    @Override
    protected ScheduledFuture<?> scheduleWithRepetition(Runnable task, long period, TimeUnit unit) {
        return this.client.getTaskScheduler().scheduleWithRepetition(task, period, period, unit);
    }

    @Override
    protected InternalCompletableFuture<Object> heartbeat(RaftGroupId groupId, long sessionId) {
        ClientMessage request = CPSessionHeartbeatSessionCodec.encodeRequest(groupId, sessionId);
        ClientInvocationFuture future = new ClientInvocation(this.client, request, "sessionManager").invoke();
        return new ClientDelegatingFuture<Object>(future, this.client.getSerializationService(), clientMessage -> null);
    }

    @Override
    protected InternalCompletableFuture<Object> closeSession(RaftGroupId groupId, Long sessionId) {
        ClientMessage request = CPSessionCloseSessionCodec.encodeRequest(groupId, sessionId);
        ClientInvocationFuture future = new ClientInvocation(this.client, request, "sessionManager").invoke();
        return new ClientDelegatingFuture<Object>(future, this.client.getSerializationService(), CPSessionCloseSessionCodec::decodeResponse);
    }

    @Override
    public void shutdownAndAwait() {
        Map<RaftGroupId, InternalCompletableFuture<Object>> futures = super.shutdown();
        ILogger logger = this.client.getLoggingService().getLogger(this.getClass());
        for (long remainingTimeNanos = TimeUnit.SECONDS.toNanos(60L); remainingTimeNanos > 0L; remainingTimeNanos -= TimeUnit.MILLISECONDS.toNanos(10L)) {
            int closed = 0;
            for (Map.Entry<RaftGroupId, InternalCompletableFuture<Object>> entry : futures.entrySet()) {
                CPGroupId groupId = entry.getKey();
                InternalCompletableFuture<Object> f = entry.getValue();
                if (!f.isDone()) continue;
                ++closed;
                try {
                    f.get();
                    logger.fine("Session closed for %s", groupId);
                }
                catch (Exception e) {
                    logger.warning("Close session failed for " + String.valueOf(groupId), e);
                }
            }
            if (closed == futures.size()) break;
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

