/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.semaphore;

import com.hazelcast.client.cp.internal.datastructures.CPClientProxy;
import com.hazelcast.client.cp.internal.session.ClientProxySessionManager;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreAcquireCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreAvailablePermitsCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreChangeCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreDrainCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreInitCodec;
import com.hazelcast.client.impl.protocol.codec.SemaphoreReleaseCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.datastructures.exception.WaitKeyCancelledException;
import com.hazelcast.cp.internal.session.SessionExpiredException;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.UuidUtil;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class SessionAwareSemaphoreProxy
extends CPClientProxy
implements ISemaphore {
    private final ClientProxySessionManager sessionManager = (ClientProxySessionManager)this.getClient().getProxySessionManager();

    public SessionAwareSemaphoreProxy(ClientContext context, RaftGroupId groupId, String proxyName, String objectName) {
        super("hz:raft:semaphoreService", proxyName, context, groupId, objectName);
    }

    @Override
    public boolean init(int permits) {
        Preconditions.checkNotNegative(permits, "Permits must be non-negative!");
        ClientMessage request = SemaphoreInitCodec.encodeRequest(this.groupId, this.objectName, permits);
        ClientMessage response = (ClientMessage)this.invokeClientRequest(request, this.objectName).joinInternal();
        return SemaphoreInitCodec.decodeResponse(response);
    }

    @Override
    public void acquire() {
        this.acquire(1);
    }

    @Override
    public void acquire(int permits) {
        Preconditions.checkPositive("permits", permits);
        long threadId = ThreadUtil.getThreadId();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        while (true) {
            long sessionId = this.sessionManager.acquireSession(this.groupId, permits);
            try {
                ClientMessage request = SemaphoreAcquireCodec.encodeRequest(this.groupId, this.objectName, sessionId, threadId, invocationUid, permits, -1L);
                this.invokeClientRequest(request, this.objectName).joinInternal();
                return;
            }
            catch (SessionExpiredException e) {
                this.sessionManager.invalidateSession(this.groupId, sessionId);
                continue;
            }
            catch (WaitKeyCancelledException e) {
                this.sessionManager.releaseSession(this.groupId, sessionId, permits);
                throw new IllegalStateException("Semaphore[" + this.objectName + "] not acquired because the acquire call on the CP group is cancelled, possibly because of another indeterminate call from the same thread.");
            }
            catch (RuntimeException e) {
                this.sessionManager.releaseSession(this.groupId, sessionId, permits);
                throw e;
            }
            break;
        }
    }

    @Override
    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryAcquire(int permits) {
        return this.tryAcquire(permits, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return this.tryAcquire(1, timeout, unit);
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
        Preconditions.checkPositive(permits, "Permits must be positive!");
        long timeoutMs = Math.max(0L, unit.toMillis(timeout));
        long threadId = ThreadUtil.getThreadId();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        while (true) {
            long start = Clock.currentTimeMillis();
            long sessionId = this.sessionManager.acquireSession(this.groupId, permits);
            try {
                ClientMessage request = SemaphoreAcquireCodec.encodeRequest(this.groupId, this.objectName, sessionId, threadId, invocationUid, permits, timeoutMs);
                ClientMessage response = (ClientMessage)this.invokeClientRequest(request, this.objectName).joinInternal();
                boolean acquired = SemaphoreAcquireCodec.decodeResponse(response);
                if (!acquired) {
                    this.sessionManager.releaseSession(this.groupId, sessionId, permits);
                }
                return acquired;
            }
            catch (SessionExpiredException e) {
                this.sessionManager.invalidateSession(this.groupId, sessionId);
                if ((timeoutMs -= Clock.currentTimeMillis() - start) > 0L) continue;
                return false;
            }
            catch (WaitKeyCancelledException e) {
                this.sessionManager.releaseSession(this.groupId, sessionId, permits);
                return false;
            }
            catch (RuntimeException e) {
                this.sessionManager.releaseSession(this.groupId, sessionId, permits);
                throw e;
            }
            break;
        }
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        Preconditions.checkPositive(permits, "Permits must be positive!");
        long sessionId = this.sessionManager.getSession(this.groupId);
        if (sessionId == -1L) {
            throw this.newIllegalStateException(null);
        }
        long threadId = ThreadUtil.getThreadId();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        try {
            ClientMessage request = SemaphoreReleaseCodec.encodeRequest(this.groupId, this.objectName, sessionId, threadId, invocationUid, permits);
            this.invokeClientRequest(request, this.objectName).joinInternal();
        }
        catch (SessionExpiredException e) {
            this.sessionManager.invalidateSession(this.groupId, sessionId);
            throw this.newIllegalStateException(e);
        }
        finally {
            this.sessionManager.releaseSession(this.groupId, sessionId, permits);
        }
    }

    @Override
    public int availablePermits() {
        ClientMessage request = SemaphoreAvailablePermitsCodec.encodeRequest(this.groupId, this.objectName);
        ClientMessage response = (ClientMessage)this.invokeClientRequest(request, this.objectName).joinInternal();
        return SemaphoreAvailablePermitsCodec.decodeResponse(response);
    }

    @Override
    public int drainPermits() {
        long threadId = ThreadUtil.getThreadId();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        while (true) {
            long sessionId = this.sessionManager.acquireSession(this.groupId, 1024);
            try {
                ClientMessage request = SemaphoreDrainCodec.encodeRequest(this.groupId, this.objectName, sessionId, threadId, invocationUid);
                ClientMessage response = (ClientMessage)this.invokeClientRequest(request, this.objectName).joinInternal();
                int count = SemaphoreDrainCodec.decodeResponse(response);
                this.sessionManager.releaseSession(this.groupId, sessionId, 1024 - count);
                return count;
            }
            catch (SessionExpiredException e) {
                this.sessionManager.invalidateSession(this.groupId, sessionId);
                continue;
            }
            catch (RuntimeException e) {
                this.sessionManager.releaseSession(this.groupId, sessionId, 1024);
                throw e;
            }
            break;
        }
    }

    @Override
    public void reducePermits(int reduction) {
        Preconditions.checkNotNegative(reduction, "Reduction must be non-negative!");
        if (reduction == 0) {
            return;
        }
        this.doChangePermits(-reduction);
    }

    @Override
    public void increasePermits(int increase) {
        Preconditions.checkNotNegative(increase, "Increase must be non-negative!");
        if (increase == 0) {
            return;
        }
        this.doChangePermits(increase);
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onDestroy() {
        ClientMessage request = CPGroupDestroyCPObjectCodec.encodeRequest(this.groupId, this.getServiceName(), this.objectName);
        this.invokeClientRequest(request, this.name).joinInternal();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }

    private void doChangePermits(int delta) {
        long sessionId = this.sessionManager.acquireSession(this.groupId);
        long threadId = ThreadUtil.getThreadId();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        try {
            ClientMessage request = SemaphoreChangeCodec.encodeRequest(this.groupId, this.objectName, sessionId, threadId, invocationUid, delta);
            this.invokeClientRequest(request, this.objectName).joinInternal();
        }
        catch (SessionExpiredException e) {
            this.sessionManager.invalidateSession(this.groupId, sessionId);
            throw this.newIllegalStateException(e);
        }
        finally {
            this.sessionManager.releaseSession(this.groupId, sessionId);
        }
    }

    private IllegalStateException newIllegalStateException(SessionExpiredException e) {
        return new IllegalStateException("No valid session!", e);
    }
}

