/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AwsClient;
import com.hazelcast.aws.AwsConfig;
import com.hazelcast.aws.AwsCredentials;
import com.hazelcast.aws.AwsCredentialsProvider;
import com.hazelcast.aws.AwsEc2Api;
import com.hazelcast.aws.AwsEcsApi;
import com.hazelcast.aws.AwsMetadataApi;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.discovery.integration.DiscoveryMode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class AwsEc2Client
implements AwsClient {
    private static final ILogger LOGGER = Logger.getLogger(AwsEc2Client.class);
    private final AwsEc2Api awsEc2Api;
    private final AwsEcsApi awsEcsApi;
    private final AwsMetadataApi awsMetadataApi;
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final AwsConfig awsConfig;

    AwsEc2Client(AwsEc2Api awsEc2Api, AwsEcsApi awsEcsApi, AwsMetadataApi awsMetadataApi, AwsCredentialsProvider awsCredentialsProvider, AwsConfig awsConfig) {
        this.awsEc2Api = awsEc2Api;
        this.awsEcsApi = awsEcsApi;
        this.awsMetadataApi = awsMetadataApi;
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.awsConfig = awsConfig;
    }

    @Override
    public Map<String, String> getAddresses() {
        AwsCredentials credentials = this.awsCredentialsProvider.credentials();
        Map<String, String> instances = Collections.emptyMap();
        if (!this.awsConfig.anyOfEcsPropertiesConfigured()) {
            instances = this.awsEc2Api.describeInstances(credentials);
        }
        if (this.awsConfig.anyOfEc2PropertiesConfigured()) {
            return instances;
        }
        if (instances.isEmpty() && DiscoveryMode.Client == this.awsConfig.getDiscoveryMode()) {
            return this.getEcsAddresses(credentials);
        }
        return instances;
    }

    private Map<String, String> getEcsAddresses(AwsCredentials credentials) {
        if (StringUtil.isNullOrEmptyAfterTrim(this.awsConfig.getCluster())) {
            throw new InvalidConfigurationException("You must define 'cluster' property if not running inside ECS cluster");
        }
        List<String> taskAddresses = this.awsEcsApi.listTaskPrivateAddresses(this.awsConfig.getCluster(), credentials);
        LOGGER.fine("AWS ECS DescribeTasks found the following addresses: %s", taskAddresses);
        return this.awsEc2Api.describeNetworkInterfaces(taskAddresses, credentials);
    }

    @Override
    public String getAvailabilityZone() {
        return this.awsMetadataApi.availabilityZoneEc2();
    }

    @Override
    public Optional<String> getPlacementGroup() {
        return this.awsMetadataApi.placementGroupEc2();
    }

    @Override
    public Optional<String> getPlacementPartitionNumber() {
        return this.awsMetadataApi.placementPartitionNumberEc2();
    }
}

