/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import java.util.Objects;

final class AwsCredentials {
    private final String accessKey;
    private final String secretKey;
    private final String token;

    private AwsCredentials(String accessKey, String secretKey, String token) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.token = token;
    }

    String getAccessKey() {
        return this.accessKey;
    }

    String getSecretKey() {
        return this.secretKey;
    }

    String getToken() {
        return this.token;
    }

    static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsCredentials that = (AwsCredentials)o;
        return Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.secretKey, that.secretKey) && Objects.equals(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hash(this.accessKey, this.secretKey, this.token);
    }

    static class Builder {
        private String accessKey;
        private String secretKey;
        private String token;

        Builder() {
        }

        Builder setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        Builder setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        Builder setToken(String token) {
            this.token = token;
            return this;
        }

        AwsCredentials build() {
            return new AwsCredentials(this.accessKey, this.secretKey, this.token);
        }
    }
}

