/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.util;

import com.hazelcast.shaded.com.amazonaws.annotation.SdkProtectedApi;
import com.hazelcast.shaded.com.amazonaws.util.BoundedCache;
import java.net.URI;
import java.util.function.Function;

@SdkProtectedApi
public final class SdkUri {
    private static volatile SdkUri instance;
    private final BoundedCache<String, URI> cache = BoundedCache.builder().mappingFunction(new Function<String, URI>(){

        @Override
        public URI apply(String s) {
            return URI.create(s);
        }
    }).build();
    private final String HTTPS_PREFIX = "https://";
    private final String HTTP_PREFIX = "http://";

    private SdkUri() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SdkUri getInstance() {
        if (instance != null) return instance;
        Class<SdkUri> clazz = SdkUri.class;
        synchronized (SdkUri.class) {
            if (instance != null) return instance;
            instance = new SdkUri();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public URI create(String s) {
        if (!this.isAccountIdUri(s)) {
            return URI.create(s);
        }
        return this.cache.get(s);
    }

    private boolean isAccountIdUri(String s) {
        int firstCharAfterScheme = 0;
        int maxIntSizeBase10 = 10;
        if (s.startsWith("https://")) {
            firstCharAfterScheme = "https://".length();
        } else if (s.startsWith("http://")) {
            firstCharAfterScheme = "http://".length();
        }
        if (s.length() > firstCharAfterScheme + maxIntSizeBase10) {
            return Character.isDigit(s.charAt(firstCharAfterScheme)) && Character.isDigit(s.charAt(firstCharAfterScheme + maxIntSizeBase10));
        }
        return false;
    }
}

