/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.util;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.lang.reflect.Field;

public class PropertyNamingStrategyUtils {
    public static void configureUpperCamelCase(ObjectMapper mapper) {
        try {
            mapper.setPropertyNamingStrategy(PropertyNamingStrategies.UPPER_CAMEL_CASE);
        }
        catch (LinkageError e) {
            PropertyNamingStrategy opStrategy = PropertyNamingStrategyUtils.getLegacyStrategy(e, "UPPER_CAMEL_CASE", "PASCAL_CASE_TO_CAMEL_CASE");
            if (null != opStrategy) {
                mapper.setPropertyNamingStrategy(opStrategy);
                return;
            }
            throw e;
        }
    }

    static PropertyNamingStrategy getLegacyStrategy(Throwable e, String ... strategyConstants) {
        for (String fieldName : strategyConstants) {
            try {
                Field field = PropertyNamingStrategy.class.getField(fieldName);
                return (PropertyNamingStrategy)field.get(null);
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
            }
        }
        return null;
    }
}

