/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum ClassLoaderHelper {


    public static URL getResource(String resource, Class<?> ... classes) {
        return ClassLoaderHelper.getResource(resource, false, classes);
    }

    public static URL getResource(String resource, boolean classesFirst, Class<?> ... classes) {
        List<URL> resources = ClassLoaderHelper.getResources(resource, classesFirst, classes);
        if (resources.isEmpty()) {
            return null;
        }
        return resources.get(0);
    }

    public static List<URL> getResources(String resource, boolean classesFirst, Class<?> ... classes) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (classesFirst) {
            urls.addAll(ClassLoaderHelper.getResourcesViaClasses(resource, classes));
            urls.addAll(ClassLoaderHelper.getResourcesViaContext(resource));
        } else {
            urls.addAll(ClassLoaderHelper.getResourcesViaContext(resource));
            urls.addAll(ClassLoaderHelper.getResourcesViaClasses(resource, classes));
        }
        URL fallbackResource = ClassLoaderHelper.class.getResource(resource);
        if (fallbackResource != null) {
            urls.add(fallbackResource);
        }
        return urls;
    }

    private static List<URL> getResourcesViaClasses(String resource, Class<?>[] classes) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (classes != null) {
            for (Class<?> c : classes) {
                URL url = c.getResource(resource);
                if (url == null) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    private static List<URL> getResourcesViaContext(String resource) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            return Collections.emptyList();
        }
        try {
            return Collections.list(loader.getResources(resource));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Class<?> loadClassViaClasses(String fqcn, Class<?>[] classes) {
        if (classes != null) {
            for (Class<?> c : classes) {
                ClassLoader loader = c.getClassLoader();
                if (loader == null) continue;
                try {
                    return loader.loadClass(fqcn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static Class<?> loadClassViaContext(String fqcn) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return loader == null ? null : loader.loadClass(fqcn);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Class<?> loadClass(String fqcn, Class<?> ... classes) throws ClassNotFoundException {
        return ClassLoaderHelper.loadClass(fqcn, true, classes);
    }

    public static Class<?> loadClass(String fqcn, boolean classesFirst, Class<?> ... classes) throws ClassNotFoundException {
        Class<?> target = null;
        if (classesFirst) {
            target = ClassLoaderHelper.loadClassViaClasses(fqcn, classes);
            if (target == null) {
                target = ClassLoaderHelper.loadClassViaContext(fqcn);
            }
        } else {
            target = ClassLoaderHelper.loadClassViaContext(fqcn);
            if (target == null) {
                target = ClassLoaderHelper.loadClassViaClasses(fqcn, classes);
            }
        }
        return target == null ? Class.forName(fqcn) : target;
    }

    public static InputStream getResourceAsStream(String resource, Class<?> ... classes) {
        return ClassLoaderHelper.getResourceAsStream(resource, false, classes);
    }

    public static InputStream getResourceAsStream(String resource, boolean classesFirst, Class<?> ... classes) {
        URL url = ClassLoaderHelper.getResource(resource, classesFirst, classes);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

