/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.transform.rpcv2cbor;

import com.hazelcast.shaded.com.amazonaws.SdkClientException;
import com.hazelcast.shaded.com.amazonaws.annotation.SdkProtectedApi;
import com.hazelcast.shaded.com.amazonaws.transform.Unmarshaller;
import com.hazelcast.shaded.com.amazonaws.transform.rpcv2cbor.RpcV2CborUnmarshallerContext;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonToken;
import com.hazelcast.shaded.com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;

@SdkProtectedApi
public class SimpleTypeRpcV2CborUnmarshallers {

    public static class ShortCborUnmarshaller
    implements Unmarshaller<Short, RpcV2CborUnmarshallerContext> {
        private static final ShortCborUnmarshaller instance = new ShortCborUnmarshaller();

        @Override
        public Short unmarshall(RpcV2CborUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.getCBORParser().getShortValue();
        }

        public static ShortCborUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class ByteBufferCborUnmarshaller
    implements Unmarshaller<ByteBuffer, RpcV2CborUnmarshallerContext> {
        private static final ByteBufferCborUnmarshaller instance = new ByteBufferCborUnmarshaller();

        @Override
        public ByteBuffer unmarshall(RpcV2CborUnmarshallerContext unmarshallerContext) throws Exception {
            return ByteBuffer.wrap(unmarshallerContext.getCBORParser().getBinaryValue());
        }

        public static ByteBufferCborUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class DateCborUnmarshaller
    implements Unmarshaller<Date, RpcV2CborUnmarshallerContext> {
        private static final DateCborUnmarshaller instance = new DateCborUnmarshaller();

        @Override
        public Date unmarshall(RpcV2CborUnmarshallerContext unmarshallerContext) throws Exception {
            return new Date((long)(unmarshallerContext.getCBORParser().getDoubleValue() * 1000.0));
        }

        public static DateCborUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class ByteCborUnmarshaller
    implements Unmarshaller<Byte, RpcV2CborUnmarshallerContext> {
        private static final ByteCborUnmarshaller instance = new ByteCborUnmarshaller();

        @Override
        public Byte unmarshall(RpcV2CborUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.getCBORParser().getByteValue();
        }

        public static ByteCborUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class LongCborUnmarshaller
    implements Unmarshaller<Long, RpcV2CborUnmarshallerContext> {
        private static final LongCborUnmarshaller instance = new LongCborUnmarshaller();

        @Override
        public Long unmarshall(RpcV2CborUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.getCBORParser().getLongValue();
        }

        public static LongCborUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class FloatCborUnmarshaller
    implements Unmarshaller<Float, RpcV2CborUnmarshallerContext> {
        private static final FloatCborUnmarshaller instance = new FloatCborUnmarshaller();

        @Override
        public Float unmarshall(RpcV2CborUnmarshallerContext unmarshallerContext) throws Exception {
            return Float.valueOf(unmarshallerContext.getCBORParser().getFloatValue());
        }

        public static FloatCborUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class BooleanCborUnmarshaller
    implements Unmarshaller<Boolean, RpcV2CborUnmarshallerContext> {
        private static final BooleanCborUnmarshaller instance = new BooleanCborUnmarshaller();

        @Override
        public Boolean unmarshall(RpcV2CborUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.getCBORParser().getBooleanValue();
        }

        public static BooleanCborUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class BigDecimalCborUnmarshaller
    implements Unmarshaller<BigDecimal, RpcV2CborUnmarshallerContext> {
        private static final BigDecimalCborUnmarshaller instance = new BigDecimalCborUnmarshaller();

        @Override
        public BigDecimal unmarshall(RpcV2CborUnmarshallerContext unmarshallerContext) throws Exception {
            CBORParser parser = unmarshallerContext.getCBORParser();
            Unmarshaller<BigInteger, RpcV2CborUnmarshallerContext> bigIntegerUnmarshaller = unmarshallerContext.getUnmarshaller(BigInteger.class);
            JsonToken current = parser.getCurrentToken();
            if (current != JsonToken.VALUE_NUMBER_FLOAT) {
                throw new SdkClientException("Invalid BigDecimal Format.");
            }
            BigDecimal value = parser.getDecimalValue();
            return value;
        }

        public static BigDecimalCborUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class BigIntegerCborUnmarshaller
    implements Unmarshaller<BigInteger, RpcV2CborUnmarshallerContext> {
        private static final BigIntegerCborUnmarshaller instance = new BigIntegerCborUnmarshaller();

        @Override
        public BigInteger unmarshall(RpcV2CborUnmarshallerContext unmarshallerContext) throws Exception {
            CBORParser parser = unmarshallerContext.getCBORParser();
            JsonToken current = parser.getCurrentToken();
            if (current == JsonToken.VALUE_NUMBER_INT) {
                return parser.getBigIntegerValue();
            }
            if (current == JsonToken.VALUE_EMBEDDED_OBJECT) {
                Object embedded = parser.getEmbeddedObject();
                return new BigInteger((byte[])embedded);
            }
            throw new SdkClientException("Invalid BigInteger Format.");
        }

        public static BigIntegerCborUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class IntegerCborUnmarshaller
    implements Unmarshaller<Integer, RpcV2CborUnmarshallerContext> {
        private static final IntegerCborUnmarshaller instance = new IntegerCborUnmarshaller();

        @Override
        public Integer unmarshall(RpcV2CborUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.getCBORParser().getIntValue();
        }

        public static IntegerCborUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class DoubleCborUnmarshaller
    implements Unmarshaller<Double, RpcV2CborUnmarshallerContext> {
        private static final DoubleCborUnmarshaller instance = new DoubleCborUnmarshaller();

        @Override
        public Double unmarshall(RpcV2CborUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.getCBORParser().getDoubleValue();
        }

        public static DoubleCborUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class StringCborUnmarshaller
    implements Unmarshaller<String, RpcV2CborUnmarshallerContext> {
        private static final StringCborUnmarshaller instance = new StringCborUnmarshaller();

        @Override
        public String unmarshall(RpcV2CborUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.readText();
        }

        public static StringCborUnmarshaller getInstance() {
            return instance;
        }
    }
}

