/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.transform.rpcv2cbor;

import com.hazelcast.shaded.com.amazonaws.transform.Unmarshaller;
import com.hazelcast.shaded.com.amazonaws.transform.rpcv2cbor.RpcV2CborUnmarshallerContext;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonToken;
import java.util.HashMap;
import java.util.Map;

public class MapUnmarshaller<K, V>
implements Unmarshaller<Map<K, V>, RpcV2CborUnmarshallerContext> {
    private final Unmarshaller<K, RpcV2CborUnmarshallerContext> keyUnmarshaller;
    private final Unmarshaller<V, RpcV2CborUnmarshallerContext> valueUnmarshaller;

    public MapUnmarshaller(Unmarshaller<K, RpcV2CborUnmarshallerContext> keyUnmarshaller, Unmarshaller<V, RpcV2CborUnmarshallerContext> valueUnmarshaller) {
        this.keyUnmarshaller = keyUnmarshaller;
        this.valueUnmarshaller = valueUnmarshaller;
    }

    @Override
    public Map<K, V> unmarshall(RpcV2CborUnmarshallerContext context) throws Exception {
        HashMap<K, V> map = new HashMap<K, V>();
        int originalDepth = context.getCurrentDepth();
        if (context.getCurrentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        while (true) {
            JsonToken token;
            if ((token = context.nextToken()) == null) {
                return map;
            }
            if (token == JsonToken.FIELD_NAME) {
                K k = this.keyUnmarshaller.unmarshall(context);
                token = context.nextToken();
                V v = this.valueUnmarshaller.unmarshall(context);
                if (v == null) continue;
                map.put(k, v);
                continue;
            }
            if ((token == JsonToken.END_ARRAY || token == JsonToken.END_OBJECT) && context.getCurrentDepth() <= originalDepth) break;
        }
        return map;
    }
}

