/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model.transform;

import com.hazelcast.shaded.com.amazonaws.SdkClientException;
import com.hazelcast.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallLocation;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingType;
import com.hazelcast.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model.Record;
import java.nio.ByteBuffer;

@SdkInternalApi
public class RecordMarshaller {
    private static final MarshallingInfo<ByteBuffer> DATA_BINDING = MarshallingInfo.builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").build();
    private static final RecordMarshaller instance = new RecordMarshaller();

    public static RecordMarshaller getInstance() {
        return instance;
    }

    public void marshall(Record record, ProtocolMarshaller protocolMarshaller) {
        if (record == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(record.getData(), DATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

