/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model;

import com.hazelcast.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.StructuredPojo;
import com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model.ContentEncoding;
import com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model.HttpEndpointCommonAttribute;
import com.hazelcast.shaded.com.amazonaws.services.kinesisfirehose.model.transform.HttpEndpointRequestConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HttpEndpointRequestConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String contentEncoding;
    private List<HttpEndpointCommonAttribute> commonAttributes;

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public HttpEndpointRequestConfiguration withContentEncoding(String contentEncoding) {
        this.setContentEncoding(contentEncoding);
        return this;
    }

    public HttpEndpointRequestConfiguration withContentEncoding(ContentEncoding contentEncoding) {
        this.contentEncoding = contentEncoding.toString();
        return this;
    }

    public List<HttpEndpointCommonAttribute> getCommonAttributes() {
        return this.commonAttributes;
    }

    public void setCommonAttributes(Collection<HttpEndpointCommonAttribute> commonAttributes) {
        if (commonAttributes == null) {
            this.commonAttributes = null;
            return;
        }
        this.commonAttributes = new ArrayList<HttpEndpointCommonAttribute>(commonAttributes);
    }

    public HttpEndpointRequestConfiguration withCommonAttributes(HttpEndpointCommonAttribute ... commonAttributes) {
        if (this.commonAttributes == null) {
            this.setCommonAttributes(new ArrayList<HttpEndpointCommonAttribute>(commonAttributes.length));
        }
        for (HttpEndpointCommonAttribute ele : commonAttributes) {
            this.commonAttributes.add(ele);
        }
        return this;
    }

    public HttpEndpointRequestConfiguration withCommonAttributes(Collection<HttpEndpointCommonAttribute> commonAttributes) {
        this.setCommonAttributes(commonAttributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContentEncoding() != null) {
            sb.append("ContentEncoding: ").append(this.getContentEncoding()).append(",");
        }
        if (this.getCommonAttributes() != null) {
            sb.append("CommonAttributes: ").append(this.getCommonAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpEndpointRequestConfiguration)) {
            return false;
        }
        HttpEndpointRequestConfiguration other = (HttpEndpointRequestConfiguration)obj;
        if (other.getContentEncoding() == null ^ this.getContentEncoding() == null) {
            return false;
        }
        if (other.getContentEncoding() != null && !other.getContentEncoding().equals(this.getContentEncoding())) {
            return false;
        }
        if (other.getCommonAttributes() == null ^ this.getCommonAttributes() == null) {
            return false;
        }
        return other.getCommonAttributes() == null || other.getCommonAttributes().equals(this.getCommonAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContentEncoding() == null ? 0 : this.getContentEncoding().hashCode());
        hashCode = 31 * hashCode + (this.getCommonAttributes() == null ? 0 : this.getCommonAttributes().hashCode());
        return hashCode;
    }

    public HttpEndpointRequestConfiguration clone() {
        try {
            return (HttpEndpointRequestConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HttpEndpointRequestConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

