/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.internal;

import com.hazelcast.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.shaded.com.amazonaws.internal.SdkInternalList;
import com.hazelcast.shaded.com.amazonaws.internal.SdkInternalMap;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallLocation;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.hazelcast.shaded.com.amazonaws.protocol.StructuredPojo;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.StructuredRpcV2CborGenerator;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.StructuredRpcV2CborMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.internal.RpcV2CborMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.internal.RpcV2CborMarshallerContext;
import com.hazelcast.shaded.com.amazonaws.util.TimestampFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class SimpleTypeRpcV2CborMarshallers {
    public static final RpcV2CborMarshaller<Void> NULL = new RpcV2CborMarshaller<Void>(){

        @Override
        public void marshall(Void val, RpcV2CborMarshallerContext context, MarshallingInfo<Void> marshallingInfo) {
            if (marshallingInfo == null) {
                context.rpcv2cborGenerator().writeNull();
            } else if (marshallingInfo.isExplicitPayloadMember()) {
                if (marshallingInfo.marshallLocationName() != null) {
                    throw new IllegalStateException("Expected marshalling location name to be null if explicit member is null");
                }
                context.emptyBodyRpcV2CborMarshaller().marshall(context.rpcv2cborGenerator());
            }
        }
    };
    public static final RpcV2CborMarshaller<String> STRING = new BaseRpcV2CborMarshaller<String>(){

        @Override
        public void marshall(String val, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<String> marshallingInfo) {
            rpcv2cborGenerator.writeValue(val);
        }
    };
    public static final RpcV2CborMarshaller<Integer> INTEGER = new BaseRpcV2CborMarshaller<Integer>(){

        @Override
        public void marshall(Integer val, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<Integer> marshallingInfo) {
            rpcv2cborGenerator.writeValue(val);
        }
    };
    public static final RpcV2CborMarshaller<Long> LONG = new BaseRpcV2CborMarshaller<Long>(){

        @Override
        public void marshall(Long val, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<Long> marshallingInfo) {
            rpcv2cborGenerator.writeValue(val);
        }
    };
    public static final RpcV2CborMarshaller<Short> SHORT = new BaseRpcV2CborMarshaller<Short>(){

        @Override
        public void marshall(Short val, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<Short> marshallingInfo) {
            rpcv2cborGenerator.writeValue(val);
        }
    };
    public static final RpcV2CborMarshaller<Float> FLOAT = new BaseRpcV2CborMarshaller<Float>(){

        @Override
        public void marshall(Float val, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<Float> marshallingInfo) {
            rpcv2cborGenerator.writeValue(val.floatValue());
        }
    };
    public static final RpcV2CborMarshaller<BigDecimal> BIG_DECIMAL = new BaseRpcV2CborMarshaller<BigDecimal>(){

        @Override
        public void marshall(BigDecimal val, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<BigDecimal> marshallingInfo) {
            rpcv2cborGenerator.writeValue(val);
        }
    };
    public static final RpcV2CborMarshaller<Double> DOUBLE = new BaseRpcV2CborMarshaller<Double>(){

        @Override
        public void marshall(Double val, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<Double> marshallingInfo) {
            rpcv2cborGenerator.writeValue(val);
        }
    };
    public static final RpcV2CborMarshaller<BigInteger> BIG_INTEGER = new BaseRpcV2CborMarshaller<BigInteger>(){

        @Override
        public void marshall(BigInteger val, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<BigInteger> marshallingInfo) {
            rpcv2cborGenerator.writeValue(val);
        }
    };
    public static final RpcV2CborMarshaller<Boolean> BOOLEAN = new BaseRpcV2CborMarshaller<Boolean>(){

        @Override
        public void marshall(Boolean val, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<Boolean> marshallingInfo) {
            rpcv2cborGenerator.writeValue(val);
        }
    };
    public static final RpcV2CborMarshaller<Date> DATE = new BaseRpcV2CborMarshaller<Date>(){

        @Override
        public void marshall(Date val, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<Date> marshallingInfo) {
            TimestampFormat timestampFormat = TimestampFormat.UNIX_TIMESTAMP;
            if (marshallingInfo != null && marshallingInfo.timestampFormat() != null) {
                timestampFormat = marshallingInfo.timestampFormat();
            }
            rpcv2cborGenerator.writeValue(val, timestampFormat);
        }
    };
    public static final RpcV2CborMarshaller<ByteBuffer> BYTE_BUFFER = new BaseRpcV2CborMarshaller<ByteBuffer>(){

        @Override
        public void marshall(ByteBuffer val, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<ByteBuffer> marshallingInfo) {
            rpcv2cborGenerator.writeValue(val);
        }
    };
    public static final RpcV2CborMarshaller<StructuredPojo> STRUCTURED = new BaseRpcV2CborMarshaller<StructuredPojo>(){

        @Override
        public void marshall(StructuredPojo val, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<StructuredPojo> marshallingInfo) {
            rpcv2cborGenerator.writeStartObject();
            val.marshall(context.protocolHandler());
            rpcv2cborGenerator.writeEndObject();
        }
    };
    public static final RpcV2CborMarshaller<List> LIST = new BaseRpcV2CborMarshaller<List>(){

        @Override
        public void marshall(List list, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<List> marshallingInfo) {
            rpcv2cborGenerator.writeStartArray();
            for (Object listValue : list) {
                context.marshall(MarshallLocation.PAYLOAD, listValue);
            }
            rpcv2cborGenerator.writeEndArray();
        }

        @Override
        protected boolean shouldEmit(List list) {
            return !list.isEmpty() || !(list instanceof SdkInternalList) || !((SdkInternalList)list).isAutoConstruct();
        }
    };
    public static final RpcV2CborMarshaller<Map> MAP = new BaseRpcV2CborMarshaller<Map>(){

        @Override
        public void marshall(Map map, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<Map> mapMarshallingInfo) {
            rpcv2cborGenerator.writeStartObject();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                Object value = entry.getValue();
                rpcv2cborGenerator.writeFieldName((String)entry.getKey());
                context.marshall(MarshallLocation.PAYLOAD, value);
            }
            rpcv2cborGenerator.writeEndObject();
        }

        @Override
        protected boolean shouldEmit(Map map) {
            return !map.isEmpty() || !(map instanceof SdkInternalMap) || !((SdkInternalMap)map).isAutoConstruct();
        }
    };

    public static <T> RpcV2CborMarshaller<T> adapt(final StructuredRpcV2CborMarshaller<T> toAdapt) {
        return new BaseRpcV2CborMarshaller<T>(){

            @Override
            public void marshall(T val, StructuredRpcV2CborGenerator rpcv2cborGenerator, RpcV2CborMarshallerContext context, MarshallingInfo<T> marshallingInfo) {
                toAdapt.marshall(val, rpcv2cborGenerator);
            }
        };
    }

    private static abstract class BaseRpcV2CborMarshaller<T>
    implements RpcV2CborMarshaller<T> {
        private BaseRpcV2CborMarshaller() {
        }

        @Override
        public final void marshall(T val, RpcV2CborMarshallerContext context, MarshallingInfo<T> marshallingInfo) {
            if (!this.shouldEmit(val)) {
                return;
            }
            if (marshallingInfo != null && marshallingInfo.marshallLocationName() != null) {
                context.rpcv2cborGenerator().writeFieldName(marshallingInfo.marshallLocationName());
            }
            this.marshall(val, context.rpcv2cborGenerator(), context, marshallingInfo);
        }

        public abstract void marshall(T var1, StructuredRpcV2CborGenerator var2, RpcV2CborMarshallerContext var3, MarshallingInfo<T> var4);

        protected boolean shouldEmit(T val) {
            return true;
        }
    }
}

