/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.internal;

import com.hazelcast.shaded.com.amazonaws.Request;
import com.hazelcast.shaded.com.amazonaws.annotation.SdkInternalApi;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallLocation;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingInfo;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingType;
import com.hazelcast.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.StructuredRpcV2CborGenerator;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.internal.EmptyBodyRpcV2CborMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.internal.MarshallerRegistry;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.internal.RpcV2CborProtocolMarshaller;

@SdkInternalApi
public class RpcV2CborMarshallerContext {
    private final StructuredRpcV2CborGenerator rpcv2cborGenerator;
    private final RpcV2CborProtocolMarshaller protocolHandler;
    private final MarshallerRegistry marshallerRegistry;
    private final Request<?> request;
    private final EmptyBodyRpcV2CborMarshaller emptyBodyMarshaller;

    private RpcV2CborMarshallerContext(Builder builder) {
        this.rpcv2cborGenerator = builder.rpcv2cborGenerator;
        this.protocolHandler = builder.protocolHandler;
        this.marshallerRegistry = builder.marshallerRegistry;
        this.request = builder.request;
        this.emptyBodyMarshaller = builder.emptyBodyMarshaller != null ? builder.emptyBodyMarshaller : EmptyBodyRpcV2CborMarshaller.EMPTY;
    }

    public StructuredRpcV2CborGenerator rpcv2cborGenerator() {
        return this.rpcv2cborGenerator;
    }

    public ProtocolMarshaller protocolHandler() {
        return this.protocolHandler;
    }

    public MarshallerRegistry marshallerRegistry() {
        return this.marshallerRegistry;
    }

    public Request<?> request() {
        return this.request;
    }

    public EmptyBodyRpcV2CborMarshaller emptyBodyRpcV2CborMarshaller() {
        return this.emptyBodyMarshaller;
    }

    public void marshall(MarshallLocation marshallLocation, Object val) {
        this.marshallerRegistry().getMarshaller(marshallLocation, val).marshall(val, this, null);
    }

    public void marshall(MarshallLocation marshallLocation, Object val, MarshallingInfo marshallingInfo) {
        this.marshallerRegistry().getMarshaller(marshallLocation, val).marshall(val, this, marshallingInfo);
    }

    public void marshall(MarshallLocation marshallLocation, Object val, String paramName) {
        this.marshallerRegistry().getMarshaller(marshallLocation, val).marshall(val, this, MarshallingInfo.builder(new MarshallingType<Object>(){

            @Override
            public boolean isDefaultMarshallerForType(Class<?> type) {
                return false;
            }
        }).marshallLocationName(paramName).build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private StructuredRpcV2CborGenerator rpcv2cborGenerator;
        private RpcV2CborProtocolMarshaller protocolHandler;
        private MarshallerRegistry marshallerRegistry;
        private Request<?> request;
        private EmptyBodyRpcV2CborMarshaller emptyBodyMarshaller;

        private Builder() {
        }

        public Builder rpcv2cborGenerator(StructuredRpcV2CborGenerator rpcv2cborGenerator) {
            this.rpcv2cborGenerator = rpcv2cborGenerator;
            return this;
        }

        public Builder protocolHandler(RpcV2CborProtocolMarshaller protocolHandler) {
            this.protocolHandler = protocolHandler;
            return this;
        }

        public Builder marshallerRegistry(MarshallerRegistry marshallerRegistry) {
            this.marshallerRegistry = marshallerRegistry;
            return this;
        }

        public Builder request(Request<?> request) {
            this.request = request;
            return this;
        }

        public Builder emptyBodyRpcV2CborMarshaller(EmptyBodyRpcV2CborMarshaller emptyBodyRpcV2CborMarshaller) {
            this.emptyBodyMarshaller = emptyBodyRpcV2CborMarshaller;
            return this;
        }

        public RpcV2CborMarshallerContext build() {
            return new RpcV2CborMarshallerContext(this);
        }
    }
}

