/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor;

import com.hazelcast.shaded.com.amazonaws.AmazonServiceException;
import com.hazelcast.shaded.com.amazonaws.AmazonWebServiceResponse;
import com.hazelcast.shaded.com.amazonaws.annotation.SdkProtectedApi;
import com.hazelcast.shaded.com.amazonaws.annotation.ThreadSafe;
import com.hazelcast.shaded.com.amazonaws.http.HttpResponseHandler;
import com.hazelcast.shaded.com.amazonaws.protocol.OperationInfo;
import com.hazelcast.shaded.com.amazonaws.protocol.Protocol;
import com.hazelcast.shaded.com.amazonaws.protocol.ProtocolRequestMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.RpcV2CborClientMetadata;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.RpcV2CborErrorResponseMetadata;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.RpcV2CborErrorShapeMetadata;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.RpcV2CborOperationMetadata;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.RpcV2CborProtocolMarshallerBuilder;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.SdkStructuredCborFactory;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.SdkStructuredRpcV2CborFactory;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.StructuredRpcV2CborGenerator;
import com.hazelcast.shaded.com.amazonaws.protocol.rpcv2cbor.internal.EmptyBodyRpcV2CborMarshaller;
import com.hazelcast.shaded.com.amazonaws.transform.JsonErrorUnmarshaller;
import com.hazelcast.shaded.com.amazonaws.transform.Unmarshaller;
import com.hazelcast.shaded.com.amazonaws.transform.rpcv2cbor.RpcV2CborUnmarshallerContext;
import java.util.ArrayList;
import java.util.List;

@ThreadSafe
@SdkProtectedApi
public class SdkRpcV2CborProtocolFactory {
    private static String RPCV2CBOR = "application/cbor";
    private final RpcV2CborClientMetadata metadata;
    private final List<JsonErrorUnmarshaller> errorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();

    public SdkRpcV2CborProtocolFactory(RpcV2CborClientMetadata metadata) {
        this.metadata = metadata;
        this.createErrorUnmarshallers();
    }

    public StructuredRpcV2CborGenerator createGenerator() {
        return this.getSdkFactory().createWriter(this.getContentType());
    }

    public String getContentType() {
        return RPCV2CBOR;
    }

    public <T> ProtocolRequestMarshaller<T> createProtocolMarshaller(OperationInfo operationInfo, T origRequest) {
        return RpcV2CborProtocolMarshallerBuilder.standard().rpcv2cborGenerator(this.createGenerator(operationInfo)).contentType(this.getContentType()).operationInfo(operationInfo).originalRequest(origRequest).emptyBodyMarshaller(this.createEmptyBodyMarshaller(operationInfo)).withAwsQueryCompatible(this.metadata.getAwsQueryCompatible()).build();
    }

    private StructuredRpcV2CborGenerator createGenerator(OperationInfo operationInfo) {
        if (operationInfo.hasPayloadMembers() || operationInfo.protocol() == Protocol.RPCV2_CBOR) {
            return this.createGenerator();
        }
        return StructuredRpcV2CborGenerator.NO_OP;
    }

    private EmptyBodyRpcV2CborMarshaller createEmptyBodyMarshaller(OperationInfo operationInfo) {
        if (operationInfo.protocol() == Protocol.API_GATEWAY) {
            throw new IllegalStateException("Detected the API_GATEWAY protocol which should not be used with this protocol factory.");
        }
        if (!operationInfo.hasPayloadMembers() || operationInfo.protocol() == Protocol.API_GATEWAY) {
            return EmptyBodyRpcV2CborMarshaller.NULL;
        }
        return EmptyBodyRpcV2CborMarshaller.EMPTY;
    }

    public <T> HttpResponseHandler<AmazonWebServiceResponse<T>> createResponseHandler(RpcV2CborOperationMetadata operationMetadata, Unmarshaller<T, RpcV2CborUnmarshallerContext> responseUnmarshaller) {
        return this.getSdkFactory().createResponseHandler(operationMetadata, responseUnmarshaller);
    }

    public HttpResponseHandler<AmazonServiceException> createErrorResponseHandler(RpcV2CborErrorResponseMetadata errorResponsMetadata) {
        return this.getSdkFactory().createErrorResponseHandler(errorResponsMetadata, this.errorUnmarshallers);
    }

    private void createErrorUnmarshallers() {
        for (RpcV2CborErrorShapeMetadata errorMetadata : this.metadata.getErrorShapeMetadata()) {
            if (errorMetadata.getExceptionUnmarshaller() != null) {
                this.errorUnmarshallers.add(errorMetadata.getExceptionUnmarshaller());
                continue;
            }
            if (errorMetadata.getModeledClass() == null) continue;
            this.errorUnmarshallers.add(new JsonErrorUnmarshaller(errorMetadata.getModeledClass(), errorMetadata.getErrorCode()));
        }
        if (this.metadata.getBaseServiceExceptionClass() != null) {
            this.errorUnmarshallers.add(new JsonErrorUnmarshaller(this.metadata.getBaseServiceExceptionClass(), null));
        }
    }

    private SdkStructuredRpcV2CborFactory getSdkFactory() {
        return SdkStructuredCborFactory.SDK_CBOR_FACTORY;
    }
}

