/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.protocol.json;

import com.hazelcast.shaded.com.amazonaws.annotation.SdkProtectedApi;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallLocation;
import com.hazelcast.shaded.com.amazonaws.protocol.MarshallingType;
import com.hazelcast.shaded.com.amazonaws.protocol.OperationInfo;
import com.hazelcast.shaded.com.amazonaws.protocol.ProtocolRequestMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.hazelcast.shaded.com.amazonaws.protocol.json.StructuredJsonMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.json.internal.EmptyBodyJsonMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.json.internal.JsonProtocolMarshaller;
import com.hazelcast.shaded.com.amazonaws.protocol.json.internal.MarshallerRegistry;
import com.hazelcast.shaded.com.amazonaws.protocol.json.internal.SimpleTypeJsonMarshallers;

@SdkProtectedApi
public class JsonProtocolMarshallerBuilder<T> {
    private StructuredJsonGenerator jsonGenerator;
    private String contentType;
    private OperationInfo operationInfo;
    private T originalRequest;
    private MarshallerRegistry.Builder marshallerRegistry;
    private EmptyBodyJsonMarshaller emptyBodyMarshaller;
    private boolean hasAwsQueryCompatible;

    public static <T> JsonProtocolMarshallerBuilder<T> standard() {
        return new JsonProtocolMarshallerBuilder<T>();
    }

    public JsonProtocolMarshallerBuilder<T> jsonGenerator(StructuredJsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> operationInfo(OperationInfo operationInfo) {
        this.operationInfo = operationInfo;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> originalRequest(T originalRequest) {
        this.originalRequest = originalRequest;
        return this;
    }

    @Deprecated
    public JsonProtocolMarshallerBuilder<T> sendExplicitNullForPayload(boolean sendExplicitNullForPayload) {
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> emptyBodyMarshaller(EmptyBodyJsonMarshaller emptyBodyMarshaller) {
        this.emptyBodyMarshaller = emptyBodyMarshaller;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> withAwsQueryCompatible(boolean hasAwsQueryCompatible) {
        this.hasAwsQueryCompatible = hasAwsQueryCompatible;
        return this;
    }

    public <MarshallT> JsonProtocolMarshallerBuilder<T> marshallerOverride(MarshallLocation marshallLocation, MarshallingType<MarshallT> marshallingType, StructuredJsonMarshaller<MarshallT> marshaller) {
        if (this.marshallerRegistry == null) {
            this.marshallerRegistry = MarshallerRegistry.builder();
        }
        this.marshallerRegistry.addMarshaller(marshallLocation, marshallingType, SimpleTypeJsonMarshallers.adapt(marshaller));
        return this;
    }

    public ProtocolRequestMarshaller<T> build() {
        return new JsonProtocolMarshaller<T>(this.jsonGenerator, this.contentType, this.operationInfo, this.originalRequest, this.marshallerRegistry, this.emptyBodyMarshaller, this.hasAwsQueryCompatible);
    }
}

