/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.internal;

import com.hazelcast.shaded.com.amazonaws.internal.SdkSSLSocket;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.net.ssl.SSLSocket;

public final class InputShutdownCheckingSslSocket
extends SdkSSLSocket {
    public InputShutdownCheckingSslSocket(SdkSSLSocket sock) {
        super(sock);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new InputShutdownCheckingOutputStream(this.sock.getOutputStream(), this.sock);
    }

    private static class InputShutdownCheckingOutputStream
    extends FilterOutputStream {
        private final SSLSocket sock;

        InputShutdownCheckingOutputStream(OutputStream out, SSLSocket sock) {
            super(out);
            this.sock = sock;
        }

        @Override
        public void write(int b) throws IOException {
            this.checkInputShutdown();
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.checkInputShutdown();
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.checkInputShutdown();
            this.out.write(b, off, len);
        }

        private void checkInputShutdown() throws IOException {
            if (this.sock.isInputShutdown()) {
                throw new IOException("Remote end is closed.");
            }
            try {
                this.sock.getInputStream();
            }
            catch (IOException inputStreamException) {
                IOException e = new IOException("Remote end is closed.");
                e.addSuppressed(inputStreamException);
                throw e;
            }
        }
    }
}

