/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.amazonaws.auth;

import com.hazelcast.shaded.com.amazonaws.auth.AWSCredentials;
import com.hazelcast.shaded.com.amazonaws.auth.AccountIdAware;
import com.hazelcast.shaded.com.amazonaws.auth.ProviderNameAware;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesCredentials
implements AWSCredentials,
AccountIdAware,
ProviderNameAware {
    private final String accessKey;
    private final String secretAccessKey;
    private final String accountId;
    private final String providerName;

    public PropertiesCredentials(File file) throws FileNotFoundException, IOException, IllegalArgumentException {
        this(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesCredentials(File file, String providerName) throws FileNotFoundException, IOException, IllegalArgumentException {
        if (!file.exists()) {
            throw new FileNotFoundException("File doesn't exist:  " + file.getAbsolutePath());
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            Properties accountProperties = new Properties();
            accountProperties.load(stream);
            if (accountProperties.getProperty("accessKey") == null || accountProperties.getProperty("secretKey") == null) {
                throw new IllegalArgumentException("The specified file (" + file.getAbsolutePath() + ") doesn't contain the expected properties 'accessKey' and 'secretKey'.");
            }
            this.accessKey = accountProperties.getProperty("accessKey");
            this.secretAccessKey = accountProperties.getProperty("secretKey");
            this.accountId = accountProperties.getProperty("accountId");
            this.providerName = providerName;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public PropertiesCredentials(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesCredentials(InputStream inputStream, String providerName) throws IOException {
        Properties accountProperties = new Properties();
        try {
            accountProperties.load(inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        if (accountProperties.getProperty("accessKey") == null || accountProperties.getProperty("secretKey") == null) {
            throw new IllegalArgumentException("The specified properties data doesn't contain the expected properties 'accessKey' and 'secretKey'.");
        }
        this.accessKey = accountProperties.getProperty("accessKey");
        this.secretAccessKey = accountProperties.getProperty("secretKey");
        this.accountId = accountProperties.getProperty("accountId");
        this.providerName = providerName;
    }

    @Override
    public String getAWSAccessKeyId() {
        return this.accessKey;
    }

    @Override
    public String getAWSSecretKey() {
        return this.secretAccessKey;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }
}

