/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl.source;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.kinesis.impl.AwsConfig;
import com.hazelcast.jet.kinesis.impl.source.HashRange;
import com.hazelcast.jet.kinesis.impl.source.InitialShardIterators;
import com.hazelcast.jet.kinesis.impl.source.KinesisSourcePSupplier;
import com.hazelcast.jet.retry.RetryStrategy;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.Record;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.Shard;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class KinesisSourcePMetaSupplier<T>
implements ProcessorMetaSupplier {
    private static final long serialVersionUID = 2L;
    @Nonnull
    private final AwsConfig awsConfig;
    @Nonnull
    private final String stream;
    @Nonnull
    private final RetryStrategy retryStrategy;
    @Nonnull
    private final InitialShardIterators initialShardIterators;
    @Nonnull
    private final EventTimePolicy<? super T> eventTimePolicy;
    @Nonnull
    private final BiFunctionEx<? super Record, ? super Shard, ? extends T> projectionFn;
    private transient Map<Address, HashRange> assignedHashRanges;

    public KinesisSourcePMetaSupplier(@Nonnull AwsConfig awsConfig, @Nonnull String stream, @Nonnull RetryStrategy retryStrategy, @Nonnull InitialShardIterators initialShardIterators, @Nonnull EventTimePolicy<? super T> eventTimePolicy, @Nonnull BiFunctionEx<? super Record, ? super Shard, ? extends T> projectionFn) {
        this.awsConfig = awsConfig;
        this.stream = stream;
        this.retryStrategy = retryStrategy;
        this.initialShardIterators = initialShardIterators;
        this.eventTimePolicy = eventTimePolicy;
        this.projectionFn = projectionFn;
    }

    public void init(@Nonnull ProcessorMetaSupplier.Context context) {
        List<Address> addresses = context.partitionAssignment().keySet().stream().toList();
        this.assignedHashRanges = KinesisSourcePMetaSupplier.assignHashRangesToMembers(addresses);
        if (context.logger().isFineEnabled()) {
            context.logger().fine("Hash ranges assigned to members: \n\t" + this.assignedHashRanges.entrySet().stream().map(Object::toString).collect(Collectors.joining("\n\t")));
        }
    }

    @Nonnull
    public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
        return address -> {
            HashRange assignedRange = this.assignedHashRanges.get(address);
            return new KinesisSourcePSupplier<T>(this.awsConfig, this.stream, this.eventTimePolicy, assignedRange, this.retryStrategy, this.initialShardIterators, this.projectionFn);
        };
    }

    @Nonnull
    private static Map<Address, HashRange> assignHashRangesToMembers(List<Address> addresses) {
        HashMap<Address, HashRange> addressRanges = new HashMap<Address, HashRange>();
        for (int i = 0; i < addresses.size(); ++i) {
            Address address = addresses.get(i);
            addressRanges.put(address, HashRange.DOMAIN.partition(i, addresses.size()));
        }
        return addressRanges;
    }

    public boolean initIsCooperative() {
        return true;
    }

    public boolean closeIsCooperative() {
        return true;
    }
}

