/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl.source;

import com.hazelcast.jet.kinesis.impl.source.KinesisDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.Shard;
import com.hazelcast.shaded.com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InitialShardIterators
implements IdentifiedDataSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Specification> specifications = new ArrayList<Specification>();

    public GetShardIteratorRequest request(String stream, Shard shard) {
        for (Specification specification : this.specifications) {
            if (!specification.matches(shard)) continue;
            return specification.request(stream, shard);
        }
        return this.defaultRequest(stream, shard);
    }

    @Nonnull
    private GetShardIteratorRequest defaultRequest(String stream, Shard shard) {
        GetShardIteratorRequest request = new GetShardIteratorRequest();
        request.setStreamName(stream);
        request.setShardId(shard.getShardId());
        request.setShardIteratorType(ShardIteratorType.AT_SEQUENCE_NUMBER);
        request.setStartingSequenceNumber(shard.getSequenceNumberRange().getStartingSequenceNumber());
        return request;
    }

    public int getFactoryId() {
        return KinesisDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 1;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.specifications.size());
        for (Specification specification : this.specifications) {
            out.writeObject((Object)specification.pattern);
            out.writeObject((Object)specification.shardIteratorType);
            out.writeObject(specification.parameter);
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.specifications = new ArrayList<Specification>(size);
        for (int i = 0; i < size; ++i) {
            this.specifications.add(new Specification((String)in.readObject(), (String)in.readObject(), (String)in.readObject()));
        }
    }

    public void add(@Nonnull String shardIdPattern, @Nonnull String shardIteratorType, @Nullable String parameter) {
        this.specifications.add(new Specification(shardIdPattern, shardIteratorType, parameter));
    }

    private static final class Specification
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Pattern pattern;
        private final ShardIteratorType shardIteratorType;
        private final Object parameter;

        Specification(String shardIdRegExp, String shardIteratorType, String parameter) {
            try {
                this.pattern = Pattern.compile(Objects.requireNonNull(shardIdRegExp, "shardIdRegExp"));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("'%s' doesn't seem to be a valid regular expression! Cause: %s", shardIdRegExp, e.getMessage()));
            }
            try {
                this.shardIteratorType = ShardIteratorType.valueOf(Objects.requireNonNull(shardIteratorType, "shardIteratorType"));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid shard iterator type. Acceptable values are: %s", shardIteratorType, Arrays.stream(ShardIteratorType.values()).map(Enum::name).collect(Collectors.joining(", "))));
            }
            switch (this.shardIteratorType) {
                case AT_SEQUENCE_NUMBER: 
                case AFTER_SEQUENCE_NUMBER: {
                    this.parameter = parameter;
                    break;
                }
                case AT_TIMESTAMP: {
                    try {
                        this.parameter = new Date(Long.parseLong(parameter));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(String.format("For shard iterator type %s a timestamp string parsable as `long` must be provided", shardIteratorType));
                    }
                }
                case TRIM_HORIZON: 
                case LATEST: {
                    if (parameter != null) {
                        throw new IllegalArgumentException(String.format("For shard iterator type %s no parameter should be provided", shardIteratorType));
                    }
                    this.parameter = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknow shard iterator type: %s", shardIteratorType));
                }
            }
        }

        public boolean matches(Shard shard) {
            String shardId = shard.getShardId();
            Matcher matcher = this.pattern.matcher(shardId);
            return matcher.matches();
        }

        public GetShardIteratorRequest request(String stream, Shard shard) {
            GetShardIteratorRequest request = new GetShardIteratorRequest();
            request.setStreamName(stream);
            request.setShardId(shard.getShardId());
            request.setShardIteratorType(this.shardIteratorType);
            if (this.shardIteratorType == ShardIteratorType.AT_SEQUENCE_NUMBER || this.shardIteratorType == ShardIteratorType.AFTER_SEQUENCE_NUMBER) {
                request.setStartingSequenceNumber((String)this.parameter);
            } else if (this.shardIteratorType == ShardIteratorType.AT_TIMESTAMP) {
                request.setTimestamp((Date)this.parameter);
            }
            return request;
        }
    }
}

