/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.pc.sources;

import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.GeneralStage;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.pc.Source;
import com.hazelcast.pc.config.StageConfig;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class JdbcSource
implements Source {
    public GeneralStage source(Pipeline pipeline, StageConfig stageConfig) {
        String url = stageConfig.getRequiredValue("url", String.class);
        String query = stageConfig.getRequiredValue("query", String.class);
        BatchSource source = Sources.jdbc((String)url, (String)query, JdbcSource::mapResultSet);
        return pipeline.readFrom(source);
    }

    private static Object mapResultSet(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        if (columnCount == 0) {
            return null;
        }
        if (columnCount == 1) {
            return JdbcSource.mapColumn(metaData, rs, 1);
        }
        ArrayList<Object> row = new ArrayList<Object>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            Object value = JdbcSource.mapColumn(metaData, rs, i);
            row.set(i, value);
        }
        return row;
    }

    private static Object mapColumn(ResultSetMetaData metaData, ResultSet rs, int index) throws SQLException {
        int columnType = metaData.getColumnType(index);
        switch (columnType) {
            case 4: {
                return rs.getInt(index);
            }
            case -5: {
                return rs.getLong(index);
            }
            case 6: {
                return Float.valueOf(rs.getFloat(index));
            }
            case 7: {
                return rs.getDouble(index);
            }
            case 12: {
                return rs.getString(index);
            }
        }
        throw new SQLException(String.format("Cannot map item with type %s for index %d in ResultSet", columnType, index));
    }
}

