/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.pc.sources;

import com.hazelcast.jet.pipeline.GeneralStage;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.pipeline.file.FileSourceBuilder;
import com.hazelcast.jet.pipeline.file.FileSources;
import com.hazelcast.pc.Source;
import com.hazelcast.pc.config.StageConfig;
import com.hazelcast.pc.exceptions.ConfigurationException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;

public class FileSource
implements Source {
    public GeneralStage source(Pipeline pipeline, StageConfig stageConfig) {
        Map options;
        Boolean ignoreFileNotFound;
        String path = stageConfig.getRequiredValue("path", String.class);
        String glob = stageConfig.getRequiredValue("glob", String.class);
        Path filePath = Paths.get(path, new String[0]);
        if (Files.exists(filePath, new LinkOption[0]) && !filePath.isAbsolute()) {
            path = filePath.toAbsolutePath().toString();
        }
        FileSourceBuilder sourceBuilder = FileSources.files((String)path).glob(glob).format((FileFormat)FileFormat.lines());
        String format = stageConfig.getOptionalValue("format", String.class);
        if (format != null) {
            sourceBuilder.format(FileSource.convertFileFormat(format));
        }
        if ((ignoreFileNotFound = stageConfig.getOptionalValue("ignore_file_not_found", Boolean.class)) != null) {
            sourceBuilder.ignoreFileNotFound(ignoreFileNotFound.booleanValue());
        }
        if ((options = stageConfig.getOptionalValue("options", Map.class)) != null) {
            for (Map.Entry entry : options.entrySet()) {
                sourceBuilder.option((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return pipeline.readFrom(sourceBuilder.build());
    }

    private static FileFormat convertFileFormat(String format) {
        switch (format.toLowerCase()) {
            case "avro": {
                return FileFormat.avro();
            }
            case "csv": {
                List ls = null;
                return FileFormat.csv(ls);
            }
            case "json": {
                return FileFormat.json();
            }
            case "text": {
                return FileFormat.text();
            }
            case "lines": {
                return FileFormat.lines();
            }
            case "parquet": {
                return FileFormat.parquet();
            }
            case "bytes": {
                return FileFormat.bytes();
            }
        }
        throw new ConfigurationException(String.format("Invalid file format: %s", format));
    }
}

