/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.pc.sinks;

import com.hazelcast.jet.kafka.KafkaSinks;
import com.hazelcast.jet.kafka.impl.HazelcastJsonValueSerializer;
import com.hazelcast.jet.pipeline.SinkStage;
import com.hazelcast.pc.Sink;
import com.hazelcast.pc.config.StageConfig;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.serialization.StringSerializer;

public class KafkaSink
implements Sink {
    @Override
    public SinkStage sink(Object stage, StageConfig stageConfig) {
        Properties props = KafkaSink.makeKafkaSinkProps(stageConfig);
        String topic = stageConfig.getRequiredValue("topic", String.class);
        com.hazelcast.jet.pipeline.Sink writer = KafkaSinks.kafka(props, topic);
        return Sink.write(stage, writer);
    }

    private static Properties makeKafkaSinkProps(StageConfig stage) {
        String valuetype;
        String keyType;
        Properties kafkaProps = new Properties();
        Map props = stage.getOptionalValue("properties", Map.class);
        if (props != null) {
            kafkaProps.putAll((Map<?, ?>)props);
        }
        if ((keyType = stage.getRequiredValue("key_serializer", String.class)) != null) {
            keyType = KafkaSink.convertSerializerType(keyType);
            kafkaProps.put("key.serializer", keyType);
        }
        if ((valuetype = stage.getRequiredValue("value_serializer", String.class)) != null) {
            valuetype = KafkaSink.convertSerializerType(valuetype);
            kafkaProps.put("value.serializer", valuetype);
        }
        return kafkaProps;
    }

    private static String convertSerializerType(String typeName) {
        if (typeName.equalsIgnoreCase("string")) {
            return StringSerializer.class.getCanonicalName();
        }
        if (typeName.equalsIgnoreCase("json")) {
            return HazelcastJsonValueSerializer.class.getCanonicalName();
        }
        return typeName;
    }
}

