/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.pc.sinks;

import com.hazelcast.jet.pipeline.SinkStage;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.pc.Sink;
import com.hazelcast.pc.config.StageConfig;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class JdbcSink
implements Sink {
    @Override
    public SinkStage sink(Object stage, StageConfig stageConfig) {
        String url = stageConfig.getRequiredValue("url", String.class);
        String query = stageConfig.getRequiredValue("query", String.class);
        com.hazelcast.jet.pipeline.Sink writer = Sinks.jdbc((String)url, (String)query, JdbcSink::bindFromObject);
        return Sink.write(stage, writer);
    }

    private static void bindFromObject(PreparedStatement stmt, Object item) throws SQLException {
        int paramCount = stmt.getParameterMetaData().getParameterCount();
        if (paramCount == 0) {
            return;
        }
        if (item instanceof List) {
            List list = (List)item;
            if (paramCount != list.size()) {
                throw new RuntimeException("The number of parameters in the query does not match the received value");
            }
            for (int i = 1; i <= paramCount; ++i) {
                JdbcSink.bindFromObject(stmt, list.get(i), i);
            }
            return;
        }
        if (paramCount != 1) {
            throw new RuntimeException("The number of parameters in the query does not match the received value");
        }
        JdbcSink.bindFromObject(stmt, item, 1);
    }

    private static void bindFromObject(PreparedStatement stmt, Object item, int index) throws SQLException {
        String className;
        switch (className = item.getClass().toString()) {
            case "java.lang.Integer": {
                stmt.setInt(index, (Integer)item);
                break;
            }
            case "java.lang.Long": {
                stmt.setLong(index, (Long)item);
                break;
            }
            case "java.lang.Float": {
                stmt.setFloat(index, ((Float)item).floatValue());
                break;
            }
            case "java.lang.Double": {
                stmt.setDouble(index, (Double)item);
                break;
            }
            case "java.lang.String": {
                stmt.setString(index, (String)item);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Cannot use item with type %s in prepared statement", className));
            }
        }
    }
}

