/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.consumer.internals.Acknowledgements;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.FetchConfig;
import org.apache.kafka.clients.consumer.internals.MemberStateListener;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.kafka.clients.consumer.internals.ShareCompletedFetch;
import org.apache.kafka.clients.consumer.internals.ShareFetchBuffer;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsAggregator;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.ShareSessionHandler;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.TimedRequestState;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.events.ShareAcknowledgementCommitCallbackEvent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.internals.IdempotentCloser;
import org.apache.kafka.common.message.ShareAcknowledgeRequestData;
import org.apache.kafka.common.message.ShareFetchRequestData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareAcknowledgeRequest;
import org.apache.kafka.common.requests.ShareAcknowledgeResponse;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareFetchResponse;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public class ShareConsumeRequestManager
implements RequestManager,
MemberStateListener,
Closeable {
    private final Time time;
    private final Logger log;
    private final LogContext logContext;
    private final String groupId;
    private final ConsumerMetadata metadata;
    private final SubscriptionState subscriptions;
    private final FetchConfig fetchConfig;
    protected final ShareFetchBuffer shareFetchBuffer;
    private final BackgroundEventHandler backgroundEventHandler;
    private final Map<Integer, ShareSessionHandler> sessionHandlers;
    private final Set<Integer> nodesWithPendingRequests;
    private final ShareFetchMetricsManager metricsManager;
    private final IdempotentCloser idempotentCloser = new IdempotentCloser();
    private Uuid memberId;
    private boolean fetchMoreRecords = false;
    private final Map<TopicIdPartition, Acknowledgements> fetchAcknowledgementsMap;
    private final Queue<AcknowledgeRequestState> acknowledgeRequestStates;
    private final long retryBackoffMs;
    private final long retryBackoffMaxMs;
    private boolean closing = false;
    private final CompletableFuture<Void> closeFuture;

    ShareConsumeRequestManager(Time time, LogContext logContext, String groupId, ConsumerMetadata metadata, SubscriptionState subscriptions, FetchConfig fetchConfig, ShareFetchBuffer shareFetchBuffer, BackgroundEventHandler backgroundEventHandler, ShareFetchMetricsManager metricsManager, long retryBackoffMs, long retryBackoffMaxMs) {
        this.time = time;
        this.log = logContext.logger(ShareConsumeRequestManager.class);
        this.logContext = logContext;
        this.groupId = groupId;
        this.metadata = metadata;
        this.subscriptions = subscriptions;
        this.fetchConfig = fetchConfig;
        this.shareFetchBuffer = shareFetchBuffer;
        this.backgroundEventHandler = backgroundEventHandler;
        this.metricsManager = metricsManager;
        this.retryBackoffMs = retryBackoffMs;
        this.retryBackoffMaxMs = retryBackoffMaxMs;
        this.sessionHandlers = new HashMap<Integer, ShareSessionHandler>();
        this.nodesWithPendingRequests = new HashSet<Integer>();
        this.acknowledgeRequestStates = new LinkedList<AcknowledgeRequestState>();
        this.fetchAcknowledgementsMap = new HashMap<TopicIdPartition, Acknowledgements>();
        this.closeFuture = new CompletableFuture();
    }

    @Override
    public NetworkClientDelegate.PollResult poll(long currentTimeMs) {
        if (this.memberId == null) {
            return NetworkClientDelegate.PollResult.EMPTY;
        }
        NetworkClientDelegate.PollResult pollResult = this.processAcknowledgements(currentTimeMs);
        if (pollResult != null) {
            return pollResult;
        }
        if (!this.fetchMoreRecords || this.closing) {
            return NetworkClientDelegate.PollResult.EMPTY;
        }
        HashMap<Node, ShareSessionHandler> handlerMap = new HashMap<Node, ShareSessionHandler>();
        Map<String, Uuid> topicIds = this.metadata.topicIds();
        for (TopicPartition topicPartition : this.partitionsToFetch()) {
            Optional<Node> optional = this.metadata.currentLeader((TopicPartition)topicPartition).leader;
            if (!optional.isPresent()) {
                this.log.debug("Requesting metadata update for partition {} since current leader node is missing", (Object)topicPartition);
                this.metadata.requestUpdate(false);
                continue;
            }
            Uuid topicId = topicIds.get(topicPartition.topic());
            if (topicId == null) {
                this.log.debug("Requesting metadata update for partition {} since topic ID is missing", (Object)topicPartition);
                this.metadata.requestUpdate(false);
                continue;
            }
            Node node = optional.get();
            if (this.nodesWithPendingRequests.contains(node.id())) {
                this.log.trace("Skipping fetch for partition {} because previous fetch request to {} has not been processed", (Object)topicPartition, (Object)node.id());
                continue;
            }
            ShareSessionHandler handler = handlerMap.computeIfAbsent(node, k -> this.sessionHandlers.computeIfAbsent(node.id(), n -> new ShareSessionHandler(this.logContext, (int)n, this.memberId)));
            TopicIdPartition tip = new TopicIdPartition(topicId, topicPartition);
            Acknowledgements acknowledgementsToSend = this.fetchAcknowledgementsMap.get(tip);
            if (acknowledgementsToSend != null) {
                this.metricsManager.recordAcknowledgementSent(acknowledgementsToSend.size());
            }
            handler.addPartitionToFetch(tip, acknowledgementsToSend);
            this.log.debug("Added fetch request for partition {} to node {}", (Object)topicPartition, (Object)node.id());
        }
        LinkedHashMap builderMap = new LinkedHashMap();
        for (Map.Entry entry2 : handlerMap.entrySet()) {
            builderMap.put(entry2.getKey(), ((ShareSessionHandler)entry2.getValue()).newShareFetchBuilder(this.groupId, this.fetchConfig));
        }
        List<NetworkClientDelegate.UnsentRequest> list = builderMap.entrySet().stream().map(entry -> {
            Node target = (Node)entry.getKey();
            this.log.trace("Building ShareFetch request to send to node {}", (Object)target.id());
            ShareFetchRequest.Builder requestBuilder = (ShareFetchRequest.Builder)entry.getValue();
            this.nodesWithPendingRequests.add(target.id());
            BiConsumer<ClientResponse, Throwable> responseHandler = (clientResponse, error) -> {
                if (error != null) {
                    this.handleShareFetchFailure(target, requestBuilder.data(), (Throwable)error);
                } else {
                    this.handleShareFetchSuccess(target, requestBuilder.data(), (ClientResponse)clientResponse);
                }
            };
            return new NetworkClientDelegate.UnsentRequest(requestBuilder, Optional.of(target)).whenComplete(responseHandler);
        }).collect(Collectors.toList());
        return new NetworkClientDelegate.PollResult(list);
    }

    public void fetch(Map<TopicIdPartition, Acknowledgements> acknowledgementsMap) {
        if (!this.fetchMoreRecords) {
            this.log.debug("Fetch more data");
            this.fetchMoreRecords = true;
        }
        acknowledgementsMap.forEach((tip, acks) -> this.fetchAcknowledgementsMap.merge((TopicIdPartition)tip, (Acknowledgements)acks, Acknowledgements::merge));
    }

    private NetworkClientDelegate.PollResult processAcknowledgements(long currentTimeMs) {
        ArrayList<NetworkClientDelegate.UnsentRequest> unsentRequests = new ArrayList<NetworkClientDelegate.UnsentRequest>();
        Iterator iterator = this.acknowledgeRequestStates.iterator();
        while (iterator.hasNext()) {
            AcknowledgeRequestState acknowledgeRequestState = (AcknowledgeRequestState)iterator.next();
            if (acknowledgeRequestState.isProcessed()) {
                iterator.remove();
                continue;
            }
            if (!acknowledgeRequestState.maybeExpire()) {
                if (this.nodesWithPendingRequests.contains(acknowledgeRequestState.nodeId)) {
                    this.log.trace("Skipping acknowledge request because previous request to {} has not been processed", (Object)acknowledgeRequestState.nodeId);
                    continue;
                }
                if (!acknowledgeRequestState.canSendRequest(currentTimeMs)) continue;
                acknowledgeRequestState.onSendAttempt(currentTimeMs);
                NetworkClientDelegate.UnsentRequest request = acknowledgeRequestState.buildRequest(currentTimeMs);
                if (request == null) continue;
                unsentRequests.add(request);
                continue;
            }
            for (TopicIdPartition tip : acknowledgeRequestState.acknowledgementsMap.keySet()) {
                this.metricsManager.recordFailedAcknowledgements(acknowledgeRequestState.getAcknowledgementsCount(tip));
                acknowledgeRequestState.handleAcknowledgeErrorCode(tip, Errors.REQUEST_TIMED_OUT);
            }
            iterator.remove();
        }
        NetworkClientDelegate.PollResult pollResult = null;
        if (!unsentRequests.isEmpty()) {
            pollResult = new NetworkClientDelegate.PollResult(unsentRequests);
        } else if (!this.acknowledgeRequestStates.isEmpty()) {
            pollResult = NetworkClientDelegate.PollResult.EMPTY;
        } else if (this.closing) {
            if (!this.closeFuture.isDone()) {
                this.log.trace("Completing acknowledgement on close");
                this.closeFuture.complete(null);
            }
            pollResult = NetworkClientDelegate.PollResult.EMPTY;
        }
        return pollResult;
    }

    public CompletableFuture<Map<TopicIdPartition, Acknowledgements>> commitSync(Map<TopicIdPartition, Acknowledgements> acknowledgementsMap, long deadlineMs) {
        AtomicInteger resultCount = new AtomicInteger();
        CompletableFuture<Map<TopicIdPartition, Acknowledgements>> future = new CompletableFuture<Map<TopicIdPartition, Acknowledgements>>();
        ResultHandler resultHandler = new ResultHandler(resultCount, Optional.of(future));
        Cluster cluster = this.metadata.fetch();
        this.sessionHandlers.forEach((nodeId, sessionHandler) -> {
            Node node = cluster.nodeById((int)nodeId);
            if (node != null) {
                HashMap<TopicIdPartition, Acknowledgements> acknowledgementsMapForNode = new HashMap<TopicIdPartition, Acknowledgements>();
                for (TopicIdPartition tip : sessionHandler.sessionPartitions()) {
                    Acknowledgements acknowledgements = (Acknowledgements)acknowledgementsMap.get(tip);
                    if (acknowledgements == null) continue;
                    acknowledgementsMapForNode.put(tip, acknowledgements);
                    this.metricsManager.recordAcknowledgementSent(acknowledgements.size());
                    this.log.debug("Added sync acknowledge request for partition {} to node {}", (Object)tip.topicPartition(), (Object)node.id());
                    resultCount.incrementAndGet();
                }
                this.acknowledgeRequestStates.add(new AcknowledgeRequestState(this.logContext, ShareConsumeRequestManager.class.getSimpleName() + ":1", deadlineMs, this.retryBackoffMs, this.retryBackoffMaxMs, (ShareSessionHandler)sessionHandler, (int)nodeId, (Map<TopicIdPartition, Acknowledgements>)acknowledgementsMapForNode, this::handleShareAcknowledgeSuccess, this::handleShareAcknowledgeFailure, resultHandler));
            }
        });
        resultHandler.completeIfEmpty();
        return future;
    }

    public void commitAsync(Map<TopicIdPartition, Acknowledgements> acknowledgementsMap) {
        Cluster cluster = this.metadata.fetch();
        AtomicInteger resultCount = new AtomicInteger();
        ResultHandler resultHandler = new ResultHandler(resultCount, Optional.empty());
        this.sessionHandlers.forEach((nodeId, sessionHandler) -> {
            Node node = cluster.nodeById((int)nodeId);
            if (node != null) {
                HashMap<TopicIdPartition, Acknowledgements> acknowledgementsMapForNode = new HashMap<TopicIdPartition, Acknowledgements>();
                for (TopicIdPartition tip : sessionHandler.sessionPartitions()) {
                    Acknowledgements acknowledgements = (Acknowledgements)acknowledgementsMap.get(tip);
                    if (acknowledgements == null) continue;
                    acknowledgementsMapForNode.put(tip, acknowledgements);
                    this.metricsManager.recordAcknowledgementSent(acknowledgements.size());
                    this.log.debug("Added async acknowledge request for partition {} to node {}", (Object)tip.topicPartition(), (Object)node.id());
                    resultCount.incrementAndGet();
                }
                this.acknowledgeRequestStates.add(new AcknowledgeRequestState(this.logContext, ShareConsumeRequestManager.class.getSimpleName() + ":2", Long.MAX_VALUE, this.retryBackoffMs, this.retryBackoffMaxMs, (ShareSessionHandler)sessionHandler, (int)nodeId, (Map<TopicIdPartition, Acknowledgements>)acknowledgementsMapForNode, this::handleShareAcknowledgeSuccess, this::handleShareAcknowledgeFailure, resultHandler));
            }
        });
    }

    public CompletableFuture<Void> acknowledgeOnClose(Map<TopicIdPartition, Acknowledgements> acknowledgementsMap, long deadlineMs) {
        Cluster cluster = this.metadata.fetch();
        AtomicInteger resultCount = new AtomicInteger();
        ResultHandler resultHandler = new ResultHandler(resultCount, Optional.empty());
        this.closing = true;
        this.sessionHandlers.forEach((nodeId, sessionHandler) -> {
            Node node = cluster.nodeById((int)nodeId);
            if (node != null) {
                HashMap<TopicIdPartition, Acknowledgements> acknowledgementsMapForNode = new HashMap<TopicIdPartition, Acknowledgements>();
                for (TopicIdPartition tip : sessionHandler.sessionPartitions()) {
                    Acknowledgements acknowledgements = (Acknowledgements)acknowledgementsMap.get(tip);
                    if (acknowledgements == null) continue;
                    acknowledgementsMapForNode.put(tip, acknowledgements);
                    this.metricsManager.recordAcknowledgementSent(acknowledgements.size());
                    this.log.debug("Added closing acknowledge request for partition {} to node {}", (Object)tip.topicPartition(), (Object)node.id());
                    resultCount.incrementAndGet();
                }
                this.acknowledgeRequestStates.add(new AcknowledgeRequestState(this.logContext, ShareConsumeRequestManager.class.getSimpleName() + ":3", deadlineMs, this.retryBackoffMs, this.retryBackoffMaxMs, (ShareSessionHandler)sessionHandler, (int)nodeId, (Map<TopicIdPartition, Acknowledgements>)acknowledgementsMapForNode, this::handleShareAcknowledgeCloseSuccess, this::handleShareAcknowledgeCloseFailure, resultHandler, true));
            }
        });
        return this.closeFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShareFetchSuccess(Node fetchTarget, ShareFetchRequestData requestData, ClientResponse resp) {
        try {
            this.log.debug("Completed ShareFetch request from node {} successfully", (Object)fetchTarget.id());
            ShareFetchResponse response = (ShareFetchResponse)resp.responseBody();
            ShareSessionHandler handler = this.sessionHandler(fetchTarget.id());
            if (handler == null) {
                this.log.error("Unable to find ShareSessionHandler for node {}. Ignoring ShareFetch response.", (Object)fetchTarget.id());
                return;
            }
            short requestVersion = resp.requestHeader().apiVersion();
            if (!handler.handleResponse(response, requestVersion)) {
                if (response.error() == Errors.UNKNOWN_TOPIC_ID) {
                    this.metadata.requestUpdate(false);
                }
                return;
            }
            LinkedHashMap responseData = new LinkedHashMap();
            response.data().responses().forEach(topicResponse -> topicResponse.partitions().forEach(partition -> responseData.put(new TopicIdPartition(topicResponse.topicId(), partition.partitionIndex(), this.metadata.topicNames().get(topicResponse.topicId())), partition)));
            Set<TopicPartition> partitions = responseData.keySet().stream().map(TopicIdPartition::topicPartition).collect(Collectors.toSet());
            ShareFetchMetricsAggregator shareFetchMetricsAggregator = new ShareFetchMetricsAggregator(this.metricsManager, partitions);
            for (Map.Entry entry : responseData.entrySet()) {
                TopicIdPartition tip = (TopicIdPartition)entry.getKey();
                ShareFetchResponseData.PartitionData partitionData = (ShareFetchResponseData.PartitionData)entry.getValue();
                this.log.debug("ShareFetch for partition {} returned fetch data {}", (Object)tip, (Object)partitionData);
                Acknowledgements acks = this.fetchAcknowledgementsMap.remove(tip);
                if (acks != null) {
                    if (partitionData.acknowledgeErrorCode() != Errors.NONE.code()) {
                        this.metricsManager.recordFailedAcknowledgements(acks.size());
                    }
                    acks.setAcknowledgeErrorCode(Errors.forCode(partitionData.acknowledgeErrorCode()));
                    Map<TopicIdPartition, Acknowledgements> acksMap = Collections.singletonMap(tip, acks);
                    ShareAcknowledgementCommitCallbackEvent event = new ShareAcknowledgementCommitCallbackEvent(acksMap);
                    this.backgroundEventHandler.add(event);
                }
                ShareCompletedFetch completedFetch = new ShareCompletedFetch(this.logContext, BufferSupplier.create(), tip, partitionData, shareFetchMetricsAggregator, requestVersion);
                this.shareFetchBuffer.add(completedFetch);
                if (partitionData.acquiredRecords().isEmpty()) continue;
                this.fetchMoreRecords = false;
            }
            this.metricsManager.recordLatency(resp.requestLatencyMs());
        }
        finally {
            this.log.debug("Removing pending request for node {} - success", (Object)fetchTarget.id());
            this.nodesWithPendingRequests.remove(fetchTarget.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShareFetchFailure(Node fetchTarget, ShareFetchRequestData requestData, Throwable error) {
        try {
            this.log.debug("Completed ShareFetch request from node {} unsuccessfully {}", (Object)fetchTarget.id(), (Object)Errors.forException(error));
            ShareSessionHandler handler = this.sessionHandler(fetchTarget.id());
            if (handler != null) {
                handler.handleError(error);
            }
            requestData.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                TopicIdPartition tip = new TopicIdPartition(topic.topicId(), partition.partitionIndex(), this.metadata.topicNames().get(topic.topicId()));
                Acknowledgements acks = this.fetchAcknowledgementsMap.remove(tip);
                if (acks != null) {
                    this.metricsManager.recordFailedAcknowledgements(acks.size());
                    acks.setAcknowledgeErrorCode(Errors.forException(error));
                    Map<TopicIdPartition, Acknowledgements> acksMap = Collections.singletonMap(tip, acks);
                    ShareAcknowledgementCommitCallbackEvent event = new ShareAcknowledgementCommitCallbackEvent(acksMap);
                    this.backgroundEventHandler.add(event);
                }
            }));
        }
        finally {
            this.log.debug("Removing pending request for node {} - failed", (Object)fetchTarget.id());
            this.nodesWithPendingRequests.remove(fetchTarget.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShareAcknowledgeSuccess(Node fetchTarget, ShareAcknowledgeRequestData requestData, AcknowledgeRequestState acknowledgeRequestState, ClientResponse resp, long currentTimeMs) {
        try {
            this.log.debug("Completed ShareAcknowledge request from node {} successfully", (Object)fetchTarget.id());
            ShareAcknowledgeResponse response = (ShareAcknowledgeResponse)resp.responseBody();
            ShareSessionHandler handler = acknowledgeRequestState.sessionHandler();
            short requestVersion = resp.requestHeader().apiVersion();
            if (!handler.handleResponse(response, requestVersion)) {
                acknowledgeRequestState.onFailedAttempt(currentTimeMs);
                if (!(response.error().exception() instanceof RetriableException) || this.closing) {
                    requestData.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                        TopicIdPartition tip = new TopicIdPartition(topic.topicId(), partition.partitionIndex(), this.metadata.topicNames().get(topic.topicId()));
                        this.metricsManager.recordFailedAcknowledgements(acknowledgeRequestState.getAcknowledgementsCount(tip));
                        acknowledgeRequestState.handleAcknowledgeErrorCode(tip, response.error());
                    }));
                    acknowledgeRequestState.processingComplete();
                }
            } else {
                response.data().responses().forEach(topic -> topic.partitions().forEach(partition -> {
                    TopicIdPartition tip = new TopicIdPartition(topic.topicId(), partition.partitionIndex(), this.metadata.topicNames().get(topic.topicId()));
                    if (partition.errorCode() != Errors.NONE.code()) {
                        this.metricsManager.recordFailedAcknowledgements(acknowledgeRequestState.getAcknowledgementsCount(tip));
                    }
                    acknowledgeRequestState.handleAcknowledgeErrorCode(tip, Errors.forCode(partition.errorCode()));
                }));
                acknowledgeRequestState.processingComplete();
            }
            this.metricsManager.recordLatency(resp.requestLatencyMs());
        }
        finally {
            this.log.debug("Removing pending request for node {} - success", (Object)fetchTarget.id());
            this.nodesWithPendingRequests.remove(fetchTarget.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShareAcknowledgeFailure(Node fetchTarget, ShareAcknowledgeRequestData requestData, AcknowledgeRequestState acknowledgeRequestState, Throwable error, long currentTimeMs) {
        try {
            this.log.debug("Completed ShareAcknowledge request from node {} unsuccessfully {}", (Object)fetchTarget.id(), (Object)Errors.forException(error));
            acknowledgeRequestState.sessionHandler().handleError(error);
            requestData.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                TopicIdPartition tip = new TopicIdPartition(topic.topicId(), partition.partitionIndex(), this.metadata.topicNames().get(topic.topicId()));
                this.metricsManager.recordFailedAcknowledgements(acknowledgeRequestState.getAcknowledgementsCount(tip));
                acknowledgeRequestState.handleAcknowledgeErrorCode(tip, Errors.forException(error));
            }));
        }
        finally {
            this.log.debug("Removing pending request for node {} - failed", (Object)fetchTarget.id());
            this.nodesWithPendingRequests.remove(fetchTarget.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShareAcknowledgeCloseSuccess(Node fetchTarget, ShareAcknowledgeRequestData requestData, AcknowledgeRequestState acknowledgeRequestState, ClientResponse resp, long currentTimeMs) {
        try {
            this.log.debug("Completed ShareAcknowledge on close request from node {} successfully", (Object)fetchTarget.id());
            ShareAcknowledgeResponse response = (ShareAcknowledgeResponse)resp.responseBody();
            response.data().responses().forEach(topic -> topic.partitions().forEach(partition -> {
                TopicIdPartition tip = new TopicIdPartition(topic.topicId(), partition.partitionIndex(), this.metadata.topicNames().get(topic.topicId()));
                if (partition.errorCode() != Errors.NONE.code()) {
                    this.metricsManager.recordFailedAcknowledgements(acknowledgeRequestState.getAcknowledgementsCount(tip));
                }
                acknowledgeRequestState.handleAcknowledgeErrorCode(tip, Errors.forCode(partition.errorCode()));
            }));
            this.metricsManager.recordLatency(resp.requestLatencyMs());
            acknowledgeRequestState.processingComplete();
        }
        finally {
            this.log.debug("Removing pending request for node {} - success", (Object)fetchTarget.id());
            this.nodesWithPendingRequests.remove(fetchTarget.id());
            this.sessionHandlers.remove(fetchTarget.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShareAcknowledgeCloseFailure(Node fetchTarget, ShareAcknowledgeRequestData requestData, AcknowledgeRequestState acknowledgeRequestState, Throwable error, long currentTimeMs) {
        try {
            this.log.debug("Completed ShareAcknowledge on close request from node {} unsuccessfully {}", (Object)fetchTarget.id(), (Object)Errors.forException(error));
            acknowledgeRequestState.sessionHandler().handleError(error);
            requestData.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                TopicIdPartition tip = new TopicIdPartition(topic.topicId(), partition.partitionIndex(), this.metadata.topicNames().get(topic.topicId()));
                this.metricsManager.recordFailedAcknowledgements(acknowledgeRequestState.getAcknowledgementsCount(tip));
                acknowledgeRequestState.handleAcknowledgeErrorCode(tip, Errors.forException(error));
            }));
        }
        finally {
            this.log.debug("Removing pending request for node {} - failed", (Object)fetchTarget.id());
            this.nodesWithPendingRequests.remove(fetchTarget.id());
            this.sessionHandlers.remove(fetchTarget.id());
        }
    }

    private List<TopicPartition> partitionsToFetch() {
        return this.subscriptions.fetchablePartitions(tp -> true);
    }

    public ShareSessionHandler sessionHandler(int node) {
        return this.sessionHandlers.get(node);
    }

    boolean hasCompletedFetches() {
        return !this.shareFetchBuffer.isEmpty();
    }

    protected void closeInternal() {
        Utils.closeQuietly(this.shareFetchBuffer, "shareFetchBuffer");
    }

    @Override
    public void close() {
        this.idempotentCloser.close(this::closeInternal);
    }

    @Override
    public void onMemberEpochUpdated(Optional<Integer> memberEpochOpt, Optional<String> memberIdOpt) {
        memberIdOpt.ifPresent(s2 -> {
            this.memberId = Uuid.fromString(s2);
        });
    }

    class ResultHandler {
        private final Map<TopicIdPartition, Acknowledgements> result = new HashMap<TopicIdPartition, Acknowledgements>();
        private final AtomicInteger remainingResults;
        private final Optional<CompletableFuture<Map<TopicIdPartition, Acknowledgements>>> future;

        ResultHandler(AtomicInteger remainingResults, Optional<CompletableFuture<Map<TopicIdPartition, Acknowledgements>>> future) {
            this.remainingResults = remainingResults;
            this.future = future;
        }

        public void complete(TopicIdPartition partition, Acknowledgements acknowledgements) {
            if (acknowledgements != null) {
                this.result.put(partition, acknowledgements);
            }
            if (this.remainingResults.decrementAndGet() == 0) {
                ShareAcknowledgementCommitCallbackEvent event = new ShareAcknowledgementCommitCallbackEvent(this.result);
                ShareConsumeRequestManager.this.backgroundEventHandler.add(event);
                this.future.ifPresent(future -> future.complete(this.result));
            }
        }

        public void completeIfEmpty() {
            if (this.remainingResults.get() == 0) {
                this.future.ifPresent(future -> future.complete(this.result));
            }
        }
    }

    @FunctionalInterface
    private static interface ResponseHandler<T> {
        public void handle(Node var1, ShareAcknowledgeRequestData var2, AcknowledgeRequestState var3, T var4, long var5);
    }

    class AcknowledgeRequestState
    extends TimedRequestState {
        private final ShareSessionHandler sessionHandler;
        private final int nodeId;
        private final Map<TopicIdPartition, Acknowledgements> acknowledgementsMap;
        private final ResponseHandler<ClientResponse> successHandler;
        private final ResponseHandler<Throwable> errorHandler;
        private boolean isProcessed;
        private final ResultHandler resultHandler;
        private final boolean onClose;

        AcknowledgeRequestState(LogContext logContext, String owner, long deadlineMs, long retryBackoffMs, long retryBackoffMaxMs, ShareSessionHandler sessionHandler, int nodeId, Map<TopicIdPartition, Acknowledgements> acknowledgementsMap, ResponseHandler<ClientResponse> successHandler, ResponseHandler<Throwable> errorHandler, ResultHandler resultHandler) {
            this(logContext, owner, deadlineMs, retryBackoffMs, retryBackoffMaxMs, sessionHandler, nodeId, acknowledgementsMap, successHandler, errorHandler, resultHandler, false);
        }

        AcknowledgeRequestState(LogContext logContext, String owner, long deadlineMs, long retryBackoffMs, long retryBackoffMaxMs, ShareSessionHandler sessionHandler, int nodeId, Map<TopicIdPartition, Acknowledgements> acknowledgementsMap, ResponseHandler<ClientResponse> successHandler, ResponseHandler<Throwable> errorHandler, ResultHandler resultHandler, boolean onClose) {
            super(logContext, owner, retryBackoffMs, retryBackoffMaxMs, AcknowledgeRequestState.deadlineTimer(ShareConsumeRequestManager.this.time, deadlineMs));
            this.isProcessed = false;
            this.sessionHandler = sessionHandler;
            this.nodeId = nodeId;
            this.acknowledgementsMap = acknowledgementsMap;
            this.successHandler = successHandler;
            this.errorHandler = errorHandler;
            this.resultHandler = resultHandler;
            this.onClose = onClose;
        }

        NetworkClientDelegate.UnsentRequest buildRequest(long currentTimeMs) {
            if (this.onClose) {
                this.sessionHandler.notifyClose();
            }
            for (Map.Entry<TopicIdPartition, Acknowledgements> entry : this.acknowledgementsMap.entrySet()) {
                this.sessionHandler.addPartitionToFetch(entry.getKey(), entry.getValue());
            }
            ShareAcknowledgeRequest.Builder requestBuilder = this.sessionHandler.newShareAcknowledgeBuilder(ShareConsumeRequestManager.this.groupId, ShareConsumeRequestManager.this.fetchConfig);
            Node nodeToSend = ShareConsumeRequestManager.this.metadata.fetch().nodeById(this.nodeId);
            ShareConsumeRequestManager.this.nodesWithPendingRequests.add(this.nodeId);
            BiConsumer<ClientResponse, Throwable> responseHandler = (clientResponse, error) -> {
                if (error != null) {
                    this.onFailedAttempt(currentTimeMs);
                    this.errorHandler.handle(nodeToSend, requestBuilder.data(), this, (Throwable)error, currentTimeMs);
                    this.processingComplete();
                } else {
                    this.successHandler.handle(nodeToSend, requestBuilder.data(), this, (ClientResponse)clientResponse, currentTimeMs);
                }
            };
            if (requestBuilder == null) {
                ShareConsumeRequestManager.this.log.trace("Building ShareAcknowledge request to send to node {} failed", (Object)nodeToSend.id());
                this.handleSessionErrorCode(Errors.SHARE_SESSION_NOT_FOUND);
                return null;
            }
            ShareConsumeRequestManager.this.log.trace("Building ShareAcknowledge request to send to node {}", (Object)nodeToSend.id());
            return new NetworkClientDelegate.UnsentRequest(requestBuilder, Optional.of(nodeToSend)).whenComplete(responseHandler);
        }

        int getAcknowledgementsCount(TopicIdPartition tip) {
            Acknowledgements acks = this.acknowledgementsMap.get(tip);
            if (acks == null) {
                return 0;
            }
            return acks.size();
        }

        void handleAcknowledgeErrorCode(TopicIdPartition tip, Errors acknowledgeErrorCode) {
            Acknowledgements acks = this.acknowledgementsMap.remove(tip);
            if (acks != null) {
                acks.setAcknowledgeErrorCode(acknowledgeErrorCode);
            }
            this.resultHandler.complete(tip, acks);
        }

        void handleSessionErrorCode(Errors errorCode) {
            this.acknowledgementsMap.forEach((tip, acks) -> {
                if (acks != null) {
                    acks.setAcknowledgeErrorCode(errorCode);
                }
                this.resultHandler.complete((TopicIdPartition)tip, (Acknowledgements)acks);
            });
            this.acknowledgementsMap.clear();
            this.processingComplete();
        }

        ShareSessionHandler sessionHandler() {
            return this.sessionHandler;
        }

        void processingComplete() {
            this.isProcessed = true;
            this.resultHandler.completeIfEmpty();
        }

        boolean isProcessed() {
            return this.isProcessed;
        }

        boolean maybeExpire() {
            return this.numAttempts > 0 && this.isExpired();
        }
    }
}

