/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.FetchMetricsRegistry;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsRegistry;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.telemetry.internals.ClientTelemetrySender;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsumerUtils {
    static final String THROW_ON_FETCH_STABLE_OFFSET_UNSUPPORTED = "internal.throw.on.fetch.stable.offset.unsupported";
    public static final long DEFAULT_CLOSE_TIMEOUT_MS = 30000L;
    public static final String CONSUMER_JMX_PREFIX = "kafka.consumer";
    public static final String CONSUMER_METRIC_GROUP_PREFIX = "consumer";
    public static final String CONSUMER_SHARE_METRIC_GROUP_PREFIX = "consumer-share";
    public static final String COORDINATOR_METRICS_SUFFIX = "-coordinator-metrics";
    public static final String CONSUMER_METRICS_SUFFIX = "-metrics";
    public static final int CONSUMER_MAX_INFLIGHT_REQUESTS_PER_CONNECTION = 100;
    private static final String CONSUMER_CLIENT_ID_METRIC_TAG = "client-id";
    private static final Logger log = LoggerFactory.getLogger(ConsumerUtils.class);

    public static ConsumerNetworkClient createConsumerNetworkClient(ConsumerConfig config, Metrics metrics, LogContext logContext, ApiVersions apiVersions, Time time, Metadata metadata, Sensor throttleTimeSensor, long retryBackoffMs, ClientTelemetrySender clientTelemetrySender) {
        NetworkClient netClient = ClientUtils.createNetworkClient(config, metrics, CONSUMER_METRIC_GROUP_PREFIX, logContext, apiVersions, time, 100, metadata, throttleTimeSensor, clientTelemetrySender);
        int heartbeatIntervalMs = config.getInt("heartbeat.interval.ms");
        return new ConsumerNetworkClient(logContext, netClient, metadata, time, retryBackoffMs, config.getInt("request.timeout.ms"), heartbeatIntervalMs);
    }

    public static LogContext createLogContext(ConsumerConfig config, GroupRebalanceConfig groupRebalanceConfig) {
        Optional<String> groupId = Optional.ofNullable(groupRebalanceConfig.groupId);
        String clientId = config.getString("client.id");
        if (groupRebalanceConfig.groupInstanceId.isPresent()) {
            return new LogContext("[Consumer instanceId=" + groupRebalanceConfig.groupInstanceId.get() + ", clientId=" + clientId + ", groupId=" + groupId.orElse("null") + "] ");
        }
        return new LogContext("[Consumer clientId=" + clientId + ", groupId=" + groupId.orElse("null") + "] ");
    }

    public static IsolationLevel configuredIsolationLevel(ConsumerConfig config) {
        String s2 = config.getString("isolation.level").toUpperCase(Locale.ROOT);
        return IsolationLevel.valueOf(s2);
    }

    public static SubscriptionState createSubscriptionState(ConsumerConfig config, LogContext logContext) {
        String s2 = config.getString("auto.offset.reset").toUpperCase(Locale.ROOT);
        OffsetResetStrategy strategy = OffsetResetStrategy.valueOf(s2);
        return new SubscriptionState(logContext, strategy);
    }

    public static Metrics createMetrics(ConsumerConfig config, Time time) {
        return ConsumerUtils.createMetrics(config, time, CommonClientConfigs.metricsReporters(config.getString("client.id"), (AbstractConfig)config));
    }

    public static Metrics createMetrics(ConsumerConfig config, Time time, List<MetricsReporter> reporters) {
        String clientId = config.getString("client.id");
        Map<String, String> metricsTags = Collections.singletonMap(CONSUMER_CLIENT_ID_METRIC_TAG, clientId);
        MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples")).timeWindow(config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS).recordLevel(Sensor.RecordingLevel.forName(config.getString("metrics.recording.level"))).tags(metricsTags);
        KafkaMetricsContext metricsContext = new KafkaMetricsContext(CONSUMER_JMX_PREFIX, config.originalsWithPrefix("metrics.context."));
        return new Metrics(metricConfig, reporters, time, metricsContext);
    }

    public static FetchMetricsManager createFetchMetricsManager(Metrics metrics) {
        Set<String> metricsTags = Collections.singleton(CONSUMER_CLIENT_ID_METRIC_TAG);
        FetchMetricsRegistry metricsRegistry = new FetchMetricsRegistry(metricsTags, CONSUMER_METRIC_GROUP_PREFIX);
        return new FetchMetricsManager(metrics, metricsRegistry);
    }

    public static ShareFetchMetricsManager createShareFetchMetricsManager(Metrics metrics) {
        Set<String> metricsTags = Collections.singleton(CONSUMER_CLIENT_ID_METRIC_TAG);
        ShareFetchMetricsRegistry metricsRegistry = new ShareFetchMetricsRegistry(metricsTags, CONSUMER_SHARE_METRIC_GROUP_PREFIX);
        return new ShareFetchMetricsManager(metrics, metricsRegistry);
    }

    public static <K, V> List<ConsumerInterceptor<K, V>> configuredConsumerInterceptors(ConsumerConfig config) {
        return ClientUtils.configuredInterceptors(config, "interceptor.classes", ConsumerInterceptor.class);
    }

    public static void refreshCommittedOffsets(Map<TopicPartition, OffsetAndMetadata> offsetsAndMetadata, ConsumerMetadata metadata, SubscriptionState subscriptions) {
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsetsAndMetadata.entrySet()) {
            TopicPartition tp = entry.getKey();
            OffsetAndMetadata offsetAndMetadata = entry.getValue();
            if (offsetAndMetadata == null) continue;
            entry.getValue().leaderEpoch().ifPresent(epoch -> metadata.updateLastSeenEpochIfNewer((TopicPartition)entry.getKey(), (int)epoch));
            if (subscriptions.isAssigned(tp)) {
                Metadata.LeaderAndEpoch leaderAndEpoch = metadata.currentLeader(tp);
                SubscriptionState.FetchPosition position = new SubscriptionState.FetchPosition(offsetAndMetadata.offset(), offsetAndMetadata.leaderEpoch(), leaderAndEpoch);
                subscriptions.seekUnvalidated(tp, position);
                log.info("Setting offset for partition {} to the committed offset {}", (Object)tp, (Object)position);
                continue;
            }
            log.info("Ignoring the returned {} since its partition {} is no longer assigned", (Object)offsetAndMetadata, (Object)tp);
        }
    }

    public static <T> T getResult(Future<T> future, Timer timer) {
        try {
            return future.get(timer.remainingMs(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw ConsumerUtils.maybeWrapAsKafkaException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new InterruptException(e);
        }
        catch (TimeoutException e) {
            throw new org.apache.kafka.common.errors.TimeoutException(e);
        }
    }

    public static <T> T getResult(Future<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw ConsumerUtils.maybeWrapAsKafkaException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new InterruptException(e);
        }
    }

    public static KafkaException maybeWrapAsKafkaException(Throwable t2) {
        if (t2 instanceof KafkaException) {
            return (KafkaException)t2;
        }
        return new KafkaException(t2);
    }

    public static KafkaException maybeWrapAsKafkaException(Throwable t2, String message) {
        if (t2 instanceof KafkaException) {
            return (KafkaException)t2;
        }
        return new KafkaException(message, t2);
    }
}

