/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.mapred.Container;

public class DeprecatedParquetInputFormat<V>
extends FileInputFormat<Void, Container<V>> {
    protected ParquetInputFormat<V> realInputFormat = new ParquetInputFormat();

    @Override
    public RecordReader<Void, Container<V>> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new RecordReaderWrapper(split, job, reporter);
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        if (DeprecatedParquetInputFormat.isTaskSideMetaData(job)) {
            return super.getSplits(job, numSplits);
        }
        List<Footer> footers = this.getFooters(job);
        List<ParquetInputSplit> splits = this.realInputFormat.getSplits(job, footers);
        if (splits == null) {
            return null;
        }
        InputSplit[] resultSplits = new InputSplit[splits.size()];
        int i = 0;
        for (ParquetInputSplit split : splits) {
            resultSplits[i++] = new ParquetInputSplitWrapper(split);
        }
        return resultSplits;
    }

    public List<Footer> getFooters(JobConf job) throws IOException {
        return this.realInputFormat.getFooters((Configuration)job, Arrays.asList(super.listStatus(job)));
    }

    public static boolean isTaskSideMetaData(JobConf job) {
        return job.getBoolean("parquet.task.side.metadata", Boolean.TRUE);
    }

    private static class ParquetInputSplitWrapper
    implements InputSplit {
        ParquetInputSplit realSplit;

        public ParquetInputSplitWrapper() {
        }

        public ParquetInputSplitWrapper(ParquetInputSplit realSplit) {
            this.realSplit = realSplit;
        }

        @Override
        public long getLength() throws IOException {
            return this.realSplit.getLength();
        }

        @Override
        public String[] getLocations() throws IOException {
            return this.realSplit.getLocations();
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.realSplit = new ParquetInputSplit();
            this.realSplit.readFields(in);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            this.realSplit.write(out);
        }
    }

    private static class RecordReaderWrapper<V>
    implements RecordReader<Void, Container<V>> {
        private ParquetRecordReader<V> realReader;
        private long splitLen;
        private Container<V> valueContainer = null;
        private boolean firstRecord = false;
        private boolean eof = false;

        public RecordReaderWrapper(InputSplit oldSplit, JobConf oldJobConf, Reporter reporter) throws IOException {
            this.splitLen = oldSplit.getLength();
            try {
                this.realReader = new ParquetRecordReader(ParquetInputFormat.getReadSupportInstance(oldJobConf), ParquetInputFormat.getFilter(oldJobConf));
                if (oldSplit instanceof ParquetInputSplitWrapper) {
                    this.realReader.initialize(((ParquetInputSplitWrapper)oldSplit).realSplit, oldJobConf, reporter);
                } else if (oldSplit instanceof FileSplit) {
                    this.realReader.initialize((FileSplit)oldSplit, oldJobConf, reporter);
                } else {
                    throw new IllegalArgumentException("Invalid split (not a FileSplit or ParquetInputSplitWrapper): " + oldSplit);
                }
                this.valueContainer = new Container();
                if (this.realReader.nextKeyValue()) {
                    this.firstRecord = true;
                    this.valueContainer.set(this.realReader.getCurrentValue());
                } else {
                    this.eof = true;
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new IOException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.realReader.close();
        }

        @Override
        public Void createKey() {
            return null;
        }

        @Override
        public Container<V> createValue() {
            return this.valueContainer;
        }

        @Override
        public long getPos() throws IOException {
            return (long)((float)this.splitLen * this.getProgress());
        }

        @Override
        public float getProgress() throws IOException {
            try {
                return this.realReader.getProgress();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new IOException(e);
            }
        }

        @Override
        public boolean next(Void key, Container<V> value) throws IOException {
            if (this.eof) {
                return false;
            }
            if (this.firstRecord) {
                value.set(this.valueContainer.get());
                this.firstRecord = false;
                return true;
            }
            try {
                if (this.realReader.nextKeyValue()) {
                    if (value != null) {
                        value.set(this.realReader.getCurrentValue());
                    }
                    return true;
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.eof = true;
            return false;
        }
    }
}

