/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonParseException;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectReader;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.functional.FutureIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class JsonSerialization<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonSerialization.class);
    private static final String UTF_8 = "UTF-8";
    private final Class<T> classType;
    private final ObjectMapper mapper;
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private static final ObjectReader MAP_READER = new ObjectMapper().readerFor(Map.class);

    public static ObjectWriter writer() {
        return WRITER;
    }

    public static ObjectReader mapReader() {
        return MAP_READER;
    }

    public JsonSerialization(Class<T> classType, boolean failOnUnknownProperties, boolean pretty) {
        Preconditions.checkArgument(classType != null, "null classType");
        this.classType = classType;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, pretty);
    }

    public String getName() {
        return this.classType.getSimpleName();
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public synchronized T fromJson(String json) throws IOException, JsonParseException, JsonMappingException {
        if (json.isEmpty()) {
            throw new EOFException("No data");
        }
        try {
            return this.mapper.readValue(json, this.classType);
        }
        catch (IOException e) {
            LOG.error("Exception while parsing json : {}\n{}", e, json, e);
            throw e;
        }
    }

    public synchronized T fromJsonStream(InputStream stream) throws IOException {
        return this.mapper.readValue(stream, this.classType);
    }

    public synchronized T load(File jsonFile) throws IOException, JsonParseException, JsonMappingException {
        if (!jsonFile.exists()) {
            throw new FileNotFoundException("No such file: " + jsonFile);
        }
        if (!jsonFile.isFile()) {
            throw new FileNotFoundException("Not a file: " + jsonFile);
        }
        if (jsonFile.length() == 0L) {
            throw new EOFException("File is empty: " + jsonFile);
        }
        try {
            return this.mapper.readValue(jsonFile, this.classType);
        }
        catch (IOException e) {
            LOG.warn("Exception while parsing json file {}", (Object)jsonFile, (Object)e);
            throw e;
        }
    }

    public void save(File file, T instance) throws IOException {
        this.writeJsonAsBytes(instance, Files.newOutputStream(file.toPath(), new OpenOption[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized T fromResource(String resource) throws IOException, JsonParseException, JsonMappingException {
        try (InputStream resStream = this.getClass().getResourceAsStream(resource);){
            if (resStream == null) {
                throw new FileNotFoundException(resource);
            }
            T t2 = this.mapper.readValue(resStream, this.classType);
            return t2;
        }
        catch (IOException e) {
            LOG.error("Exception while parsing json resource {}", (Object)resource, (Object)e);
            throw e;
        }
    }

    public T fromInstance(T instance) throws IOException {
        return this.fromJson(this.toJson(instance));
    }

    public T load(FileSystem fs, Path path) throws IOException {
        return this.load(fs, path, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T load(FileSystem fs, Path path, @Nullable FileStatus status) throws IOException {
        if (status != null && status.getLen() == 0L) {
            throw new EOFException("No data in " + path);
        }
        FutureDataInputStreamBuilder builder = (FutureDataInputStreamBuilder)fs.openFile(path).opt("fs.option.openfile.read.policy", "whole-file");
        if (status != null) {
            builder.withFileStatus(status);
        }
        try (FSDataInputStream dataInputStream = (FSDataInputStream)FutureIO.awaitFuture(builder.build());){
            T t2 = this.fromJsonStream(dataInputStream);
            return t2;
        }
        catch (JsonProcessingException e) {
            throw new PathIOException(path.toString(), "Failed to read JSON file " + (Object)((Object)e), e);
        }
    }

    public void save(FileSystem fs, Path path, T instance, boolean overwrite) throws IOException {
        this.writeJsonAsBytes(instance, fs.create(path, overwrite));
    }

    public void writeJsonAsBytes(T instance, OutputStream dataOutputStream) throws IOException {
        try {
            dataOutputStream.write(this.toBytes(instance));
        }
        finally {
            dataOutputStream.close();
        }
    }

    public byte[] toBytes(T instance) throws IOException {
        return this.mapper.writeValueAsBytes(instance);
    }

    public T fromBytes(byte[] bytes) throws IOException {
        return this.fromJson(new String(bytes, 0, bytes.length, UTF_8));
    }

    public synchronized String toJson(T instance) throws JsonProcessingException {
        return this.mapper.writeValueAsString(instance);
    }

    public String toString(T instance) {
        Preconditions.checkArgument(instance != null, "Null instance argument");
        try {
            return this.toJson(instance);
        }
        catch (JsonProcessingException e) {
            return "Failed to convert to a string: " + (Object)((Object)e);
        }
    }
}

