/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.security.token.delegation.DelegationTokenLoadingCache;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SQLDelegationTokenSecretManager<TokenIdent extends AbstractDelegationTokenIdentifier>
extends AbstractDelegationTokenSecretManager<TokenIdent> {
    private static final Logger LOG = LoggerFactory.getLogger(SQLDelegationTokenSecretManager.class);
    public static final String SQL_DTSM_CONF_PREFIX = "sql-dt-secret-manager.";
    private static final String SQL_DTSM_TOKEN_SEQNUM_BATCH_SIZE = "sql-dt-secret-manager.token.seqnum.batch.size";
    public static final int DEFAULT_SEQ_NUM_BATCH_SIZE = 10;
    public static final String SQL_DTSM_TOKEN_MAX_CLEANUP_RESULTS = "sql-dt-secret-manager.token.max.cleanup.results";
    public static final int SQL_DTSM_TOKEN_MAX_CLEANUP_RESULTS_DEFAULT = 1000;
    public static final String SQL_DTSM_TOKEN_LOADING_CACHE_EXPIRATION = "sql-dt-secret-manager.token.loading.cache.expiration";
    public static final long SQL_DTSM_TOKEN_LOADING_CACHE_EXPIRATION_DEFAULT = TimeUnit.SECONDS.toMillis(10L);
    public static final String SQL_DTSM_TOKEN_LOADING_CACHE_MAX_SIZE = "sql-dt-secret-manager.token.loading.cache.max.size";
    public static final long SQL_DTSM_TOKEN_LOADING_CACHE_MAX_SIZE_DEFAULT = 100000L;
    private final int seqNumBatchSize;
    private final int maxTokenCleanupResults;
    private int currentSeqNum;
    private int currentMaxSeqNum;

    public SQLDelegationTokenSecretManager(Configuration conf) {
        super(conf.getLong("delegation-token.update-interval.sec", 86400L) * 1000L, conf.getLong("delegation-token.max-lifetime.sec", 604800L) * 1000L, conf.getLong("delegation-token.renew-interval.sec", 86400L) * 1000L, conf.getLong("delegation-token.removal-scan-interval.sec", 3600L) * 1000L);
        this.seqNumBatchSize = conf.getInt(SQL_DTSM_TOKEN_SEQNUM_BATCH_SIZE, 10);
        this.maxTokenCleanupResults = conf.getInt(SQL_DTSM_TOKEN_MAX_CLEANUP_RESULTS, 1000);
        long cacheExpirationMs = conf.getTimeDuration(SQL_DTSM_TOKEN_LOADING_CACHE_EXPIRATION, SQL_DTSM_TOKEN_LOADING_CACHE_EXPIRATION_DEFAULT, TimeUnit.MILLISECONDS);
        long maximumCacheSize = conf.getLong(SQL_DTSM_TOKEN_LOADING_CACHE_MAX_SIZE, 100000L);
        this.currentTokens = new DelegationTokenLoadingCache<AbstractDelegationTokenIdentifier, AbstractDelegationTokenSecretManager.DelegationTokenInformation>(cacheExpirationMs, maximumCacheSize, this::getTokenInfoFromSQL);
    }

    @Override
    protected void storeToken(TokenIdent ident, AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(bos);){
            tokenInfo.write(dos);
            this.insertToken(((AbstractDelegationTokenIdentifier)ident).getSequenceNumber(), ((TokenIdentifier)ident).getBytes(), bos.toByteArray());
            super.storeToken(ident, tokenInfo);
        }
        catch (SQLException e) {
            throw new IOException("Failed to store token in SQL secret manager", e);
        }
    }

    @Override
    protected void updateToken(TokenIdent ident, AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(bos);){
            tokenInfo.write(dos);
            this.updateToken(((AbstractDelegationTokenIdentifier)ident).getSequenceNumber(), ((TokenIdentifier)ident).getBytes(), bos.toByteArray());
            super.updateToken(ident, tokenInfo);
        }
        catch (SQLException e) {
            throw new IOException("Failed to update token in SQL secret manager", e);
        }
    }

    @Override
    public synchronized TokenIdent cancelToken(Token<TokenIdent> token, String canceller) throws IOException {
        TokenIdent id = this.createTokenIdent(token.getIdentifier());
        this.getTokenInfo(id);
        return super.cancelToken(token, canceller);
    }

    @Override
    protected Map<TokenIdent, AbstractDelegationTokenSecretManager.DelegationTokenInformation> getCandidateTokensForCleanup() {
        HashMap<TokenIdent, AbstractDelegationTokenSecretManager.DelegationTokenInformation> tokens = new HashMap<TokenIdent, AbstractDelegationTokenSecretManager.DelegationTokenInformation>();
        try {
            long maxModifiedTime = Time.now() - this.getTokenRenewInterval();
            Map<byte[], byte[]> tokenInfoBytesList = this.selectStaleTokenInfos(maxModifiedTime, this.maxTokenCleanupResults);
            LOG.info("Found {} tokens for cleanup", (Object)tokenInfoBytesList.size());
            for (Map.Entry<byte[], byte[]> tokenInfoBytes : tokenInfoBytesList.entrySet()) {
                TokenIdent tokenIdent = this.createTokenIdent(tokenInfoBytes.getKey());
                AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = this.createTokenInfo(tokenInfoBytes.getValue());
                tokens.put(tokenIdent, tokenInfo);
            }
        }
        catch (IOException | SQLException e) {
            LOG.error("Failed to get candidate tokens for cleanup in SQL secret manager", e);
        }
        return tokens;
    }

    @Override
    protected void removeStoredToken(TokenIdent ident) throws IOException {
        try {
            this.deleteToken(((AbstractDelegationTokenIdentifier)ident).getSequenceNumber(), ((TokenIdentifier)ident).getBytes());
        }
        catch (SQLException e) {
            LOG.warn("Failed to remove token in SQL secret manager", e);
        }
    }

    @Override
    protected void removeExpiredStoredToken(TokenIdent ident) {
        try {
            AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = this.getTokenInfoFromSQL(ident);
            if (tokenInfo.getRenewDate() >= Time.now()) {
                LOG.info("Token was renewed by a different router and has not been deleted: {}", (Object)ident);
                return;
            }
            this.removeStoredToken(ident);
        }
        catch (NoSuchElementException e) {
            LOG.info("Token has already been deleted by a different router: {}", (Object)ident);
        }
        catch (Exception e) {
            LOG.warn("Could not remove token {}", (Object)ident, (Object)e);
        }
    }

    @VisibleForTesting
    protected AbstractDelegationTokenSecretManager.DelegationTokenInformation getTokenInfoFromSQL(TokenIdent ident) {
        try {
            byte[] tokenInfoBytes = this.selectTokenInfo(((AbstractDelegationTokenIdentifier)ident).getSequenceNumber(), ((TokenIdentifier)ident).getBytes());
            if (tokenInfoBytes == null) {
                throw new NoSuchElementException("Token not found in SQL secret manager: " + ident);
            }
            return this.createTokenInfo(tokenInfoBytes);
        }
        catch (IOException | SQLException e) {
            LOG.error("Failed to get token in SQL secret manager", e);
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private TokenIdent createTokenIdent(byte[] tokenIdentBytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AbstractDelegationTokenSecretManager.DelegationTokenInformation createTokenInfo(byte[] tokenInfoBytes) throws IOException {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = new AbstractDelegationTokenSecretManager.DelegationTokenInformation();
        try (ByteArrayInputStream bis = new ByteArrayInputStream(tokenInfoBytes);
             DataInputStream dis = new DataInputStream(bis);){
            tokenInfo.readFields(dis);
        }
        return tokenInfo;
    }

    @Override
    public int getDelegationTokenSeqNum() {
        try {
            return this.selectSequenceNum();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get token sequence number in SQL secret manager", e);
        }
    }

    @Override
    public void setDelegationTokenSeqNum(int seqNum) {
        try {
            this.updateSequenceNum(seqNum);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to update token sequence number in SQL secret manager", e);
        }
    }

    @Override
    public synchronized int incrementDelegationTokenSeqNum() {
        if (this.currentSeqNum >= this.currentMaxSeqNum) {
            try {
                this.currentSeqNum = this.incrementSequenceNum(this.seqNumBatchSize);
                this.currentMaxSeqNum = this.currentSeqNum + this.seqNumBatchSize;
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to increment token sequence number in SQL secret manager", e);
            }
        }
        return ++this.currentSeqNum;
    }

    @Override
    protected void storeDelegationKey(DelegationKey key) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(bos);){
            key.write(dos);
            this.insertDelegationKey(key.getKeyId(), bos.toByteArray());
            super.storeDelegationKey(key);
        }
        catch (SQLException e) {
            throw new IOException("Failed to store delegation key in SQL secret manager", e);
        }
    }

    @Override
    protected void updateDelegationKey(DelegationKey key) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(bos);){
            key.write(dos);
            this.updateDelegationKey(key.getKeyId(), bos.toByteArray());
            super.updateDelegationKey(key);
        }
        catch (SQLException e) {
            throw new IOException("Failed to update delegation key in SQL secret manager", e);
        }
    }

    @Override
    protected void removeStoredMasterKey(DelegationKey key) {
        try {
            this.deleteDelegationKey(key.getKeyId());
        }
        catch (SQLException e) {
            LOG.warn("Failed to remove delegation key in SQL secret manager", e);
        }
    }

    @Override
    protected DelegationKey getDelegationKey(int keyId) {
        DelegationKey delegationKey;
        block27: {
            delegationKey = super.getDelegationKey(keyId);
            if (delegationKey == null) {
                try {
                    byte[] delegationKeyBytes = this.selectDelegationKey(keyId);
                    if (delegationKeyBytes == null) break block27;
                    delegationKey = new DelegationKey();
                    try (ByteArrayInputStream bis = new ByteArrayInputStream(delegationKeyBytes);
                         DataInputStream dis = new DataInputStream(bis);){
                        delegationKey.readFields(dis);
                    }
                    this.allKeys.put(keyId, delegationKey);
                }
                catch (IOException | SQLException e) {
                    LOG.error("Failed to get delegation key in SQL secret manager", e);
                }
            }
        }
        return delegationKey;
    }

    @Override
    public int getCurrentKeyId() {
        try {
            return this.selectKeyId();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get delegation key id in SQL secret manager", e);
        }
    }

    @Override
    public void setCurrentKeyId(int keyId) {
        try {
            this.updateKeyId(keyId);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set delegation key id in SQL secret manager", e);
        }
    }

    @Override
    public int incrementCurrentKeyId() {
        try {
            return this.incrementKeyId(1) + 1;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to increment delegation key id in SQL secret manager", e);
        }
    }

    protected abstract byte[] selectTokenInfo(int var1, byte[] var2) throws SQLException;

    protected abstract Map<byte[], byte[]> selectStaleTokenInfos(long var1, int var3) throws SQLException;

    protected abstract void insertToken(int var1, byte[] var2, byte[] var3) throws SQLException;

    protected abstract void updateToken(int var1, byte[] var2, byte[] var3) throws SQLException;

    protected abstract void deleteToken(int var1, byte[] var2) throws SQLException;

    protected abstract byte[] selectDelegationKey(int var1) throws SQLException;

    protected abstract void insertDelegationKey(int var1, byte[] var2) throws SQLException;

    protected abstract void updateDelegationKey(int var1, byte[] var2) throws SQLException;

    protected abstract void deleteDelegationKey(int var1) throws SQLException;

    protected abstract int selectSequenceNum() throws SQLException;

    protected abstract void updateSequenceNum(int var1) throws SQLException;

    protected abstract int incrementSequenceNum(int var1) throws SQLException;

    protected abstract int selectKeyId() throws SQLException;

    protected abstract void updateKeyId(int var1) throws SQLException;

    protected abstract int incrementKeyId(int var1) throws SQLException;
}

