/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.api.records.impl.pb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.CountersPBImpl;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.TaskAttemptIdPBImpl;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.TaskIdPBImpl;
import org.apache.hadoop.mapreduce.v2.proto.MRProtos;
import org.apache.hadoop.mapreduce.v2.util.MRProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoBase;

public class TaskReportPBImpl
extends ProtoBase<MRProtos.TaskReportProto>
implements TaskReport {
    MRProtos.TaskReportProto proto = MRProtos.TaskReportProto.getDefaultInstance();
    MRProtos.TaskReportProto.Builder builder = null;
    boolean viaProto = false;
    private TaskId taskId = null;
    private org.apache.hadoop.mapreduce.v2.api.records.Counters counters = null;
    private Counters rawCounters = null;
    private List<TaskAttemptId> runningAttempts = null;
    private TaskAttemptId successfulAttemptId = null;
    private List<String> diagnostics = null;
    private String status;

    public TaskReportPBImpl() {
        this.builder = MRProtos.TaskReportProto.newBuilder();
    }

    public TaskReportPBImpl(MRProtos.TaskReportProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public MRProtos.TaskReportProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.taskId != null) {
            this.builder.setTaskId(this.convertToProtoFormat(this.taskId));
        }
        this.convertRawCountersToCounters();
        if (this.counters != null) {
            this.builder.setCounters(this.convertToProtoFormat(this.counters));
        }
        if (this.runningAttempts != null) {
            this.addRunningAttemptsToProto();
        }
        if (this.successfulAttemptId != null) {
            this.builder.setSuccessfulAttempt(this.convertToProtoFormat(this.successfulAttemptId));
        }
        if (this.diagnostics != null) {
            this.addDiagnosticsToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = MRProtos.TaskReportProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public org.apache.hadoop.mapreduce.v2.api.records.Counters getCounters() {
        MRProtos.TaskReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        this.convertRawCountersToCounters();
        if (this.counters != null) {
            return this.counters;
        }
        if (!p.hasCounters()) {
            return null;
        }
        this.counters = this.convertFromProtoFormat(p.getCounters());
        return this.counters;
    }

    @Override
    public void setCounters(org.apache.hadoop.mapreduce.v2.api.records.Counters counters) {
        this.maybeInitBuilder();
        if (counters == null) {
            this.builder.clearCounters();
        }
        this.counters = counters;
        this.rawCounters = null;
    }

    @Override
    public Counters getRawCounters() {
        return this.rawCounters;
    }

    @Override
    public void setRawCounters(Counters rCounters) {
        this.setCounters(null);
        this.rawCounters = rCounters;
    }

    private void convertRawCountersToCounters() {
        if (this.counters == null && this.rawCounters != null) {
            this.counters = TypeConverter.toYarn(this.rawCounters);
            this.rawCounters = null;
        }
    }

    @Override
    public long getStartTime() {
        MRProtos.TaskReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getStartTime();
    }

    @Override
    public void setStartTime(long startTime) {
        this.maybeInitBuilder();
        this.builder.setStartTime(startTime);
    }

    @Override
    public long getFinishTime() {
        MRProtos.TaskReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getFinishTime();
    }

    @Override
    public void setFinishTime(long finishTime) {
        this.maybeInitBuilder();
        this.builder.setFinishTime(finishTime);
    }

    @Override
    public TaskId getTaskId() {
        MRProtos.TaskReportProtoOrBuilder p;
        MRProtos.TaskReportProtoOrBuilder taskReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.taskId != null) {
            return this.taskId;
        }
        if (!p.hasTaskId()) {
            return null;
        }
        this.taskId = this.convertFromProtoFormat(p.getTaskId());
        return this.taskId;
    }

    @Override
    public void setTaskId(TaskId taskId) {
        this.maybeInitBuilder();
        if (taskId == null) {
            this.builder.clearTaskId();
        }
        this.taskId = taskId;
    }

    @Override
    public float getProgress() {
        MRProtos.TaskReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getProgress();
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setProgress(float progress) {
        this.maybeInitBuilder();
        this.builder.setProgress(progress);
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public TaskState getTaskState() {
        MRProtos.TaskReportProtoOrBuilder p;
        MRProtos.TaskReportProtoOrBuilder taskReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasTaskState()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getTaskState());
    }

    @Override
    public void setTaskState(TaskState taskState) {
        this.maybeInitBuilder();
        if (taskState == null) {
            this.builder.clearTaskState();
            return;
        }
        this.builder.setTaskState(this.convertToProtoFormat(taskState));
    }

    @Override
    public List<TaskAttemptId> getRunningAttemptsList() {
        this.initRunningAttempts();
        return this.runningAttempts;
    }

    @Override
    public TaskAttemptId getRunningAttempt(int index) {
        this.initRunningAttempts();
        return this.runningAttempts.get(index);
    }

    @Override
    public int getRunningAttemptsCount() {
        this.initRunningAttempts();
        return this.runningAttempts.size();
    }

    private void initRunningAttempts() {
        if (this.runningAttempts != null) {
            return;
        }
        MRProtos.TaskReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<MRProtos.TaskAttemptIdProto> list = p.getRunningAttemptsList();
        this.runningAttempts = new ArrayList<TaskAttemptId>();
        for (MRProtos.TaskAttemptIdProto c : list) {
            this.runningAttempts.add(this.convertFromProtoFormat(c));
        }
    }

    @Override
    public void addAllRunningAttempts(List<TaskAttemptId> runningAttempts) {
        if (runningAttempts == null) {
            return;
        }
        this.initRunningAttempts();
        this.runningAttempts.addAll(runningAttempts);
    }

    private void addRunningAttemptsToProto() {
        this.maybeInitBuilder();
        this.builder.clearRunningAttempts();
        if (this.runningAttempts == null) {
            return;
        }
        Iterable<MRProtos.TaskAttemptIdProto> iterable = new Iterable<MRProtos.TaskAttemptIdProto>(){

            @Override
            public Iterator<MRProtos.TaskAttemptIdProto> iterator() {
                return new Iterator<MRProtos.TaskAttemptIdProto>(){
                    Iterator<TaskAttemptId> iter;
                    {
                        this.iter = TaskReportPBImpl.this.runningAttempts.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public MRProtos.TaskAttemptIdProto next() {
                        return TaskReportPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllRunningAttempts((Iterable<? extends MRProtos.TaskAttemptIdProto>)iterable);
    }

    @Override
    public void addRunningAttempt(TaskAttemptId runningAttempts) {
        this.initRunningAttempts();
        this.runningAttempts.add(runningAttempts);
    }

    @Override
    public void removeRunningAttempt(int index) {
        this.initRunningAttempts();
        this.runningAttempts.remove(index);
    }

    @Override
    public void clearRunningAttempts() {
        this.initRunningAttempts();
        this.runningAttempts.clear();
    }

    @Override
    public TaskAttemptId getSuccessfulAttempt() {
        MRProtos.TaskReportProtoOrBuilder p;
        MRProtos.TaskReportProtoOrBuilder taskReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.successfulAttemptId != null) {
            return this.successfulAttemptId;
        }
        if (!p.hasSuccessfulAttempt()) {
            return null;
        }
        this.successfulAttemptId = this.convertFromProtoFormat(p.getSuccessfulAttempt());
        return this.successfulAttemptId;
    }

    @Override
    public void setSuccessfulAttempt(TaskAttemptId successfulAttempt) {
        this.maybeInitBuilder();
        if (successfulAttempt == null) {
            this.builder.clearSuccessfulAttempt();
        }
        this.successfulAttemptId = successfulAttempt;
    }

    @Override
    public List<String> getDiagnosticsList() {
        this.initDiagnostics();
        return this.diagnostics;
    }

    @Override
    public String getDiagnostics(int index) {
        this.initDiagnostics();
        return this.diagnostics.get(index);
    }

    @Override
    public int getDiagnosticsCount() {
        this.initDiagnostics();
        return this.diagnostics.size();
    }

    private void initDiagnostics() {
        if (this.diagnostics != null) {
            return;
        }
        MRProtos.TaskReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<String> list = p.getDiagnosticsList();
        this.diagnostics = new ArrayList<String>();
        for (String c : list) {
            this.diagnostics.add(c);
        }
    }

    @Override
    public void addAllDiagnostics(List<String> diagnostics) {
        if (diagnostics == null) {
            return;
        }
        this.initDiagnostics();
        this.diagnostics.addAll(diagnostics);
    }

    private void addDiagnosticsToProto() {
        this.maybeInitBuilder();
        this.builder.clearDiagnostics();
        if (this.diagnostics == null) {
            return;
        }
        this.builder.addAllDiagnostics(this.diagnostics);
    }

    @Override
    public void addDiagnostics(String diagnostics) {
        this.initDiagnostics();
        this.diagnostics.add(diagnostics);
    }

    @Override
    public void removeDiagnostics(int index) {
        this.initDiagnostics();
        this.diagnostics.remove(index);
    }

    @Override
    public void clearDiagnostics() {
        this.initDiagnostics();
        this.diagnostics.clear();
    }

    private CountersPBImpl convertFromProtoFormat(MRProtos.CountersProto p) {
        return new CountersPBImpl(p);
    }

    private MRProtos.CountersProto convertToProtoFormat(org.apache.hadoop.mapreduce.v2.api.records.Counters t2) {
        return ((CountersPBImpl)t2).getProto();
    }

    private TaskIdPBImpl convertFromProtoFormat(MRProtos.TaskIdProto p) {
        return new TaskIdPBImpl(p);
    }

    private MRProtos.TaskIdProto convertToProtoFormat(TaskId t2) {
        return ((TaskIdPBImpl)t2).getProto();
    }

    private MRProtos.TaskStateProto convertToProtoFormat(TaskState e) {
        return MRProtoUtils.convertToProtoFormat(e);
    }

    private TaskState convertFromProtoFormat(MRProtos.TaskStateProto e) {
        return MRProtoUtils.convertFromProtoFormat(e);
    }

    private TaskAttemptIdPBImpl convertFromProtoFormat(MRProtos.TaskAttemptIdProto p) {
        return new TaskAttemptIdPBImpl(p);
    }

    private MRProtos.TaskAttemptIdProto convertToProtoFormat(TaskAttemptId t2) {
        return ((TaskAttemptIdPBImpl)t2).getProto();
    }
}

