/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.thirdparty.com.google.common.cache.Cache;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.thirdparty.com.google.common.cache.RemovalListener;
import org.apache.hadoop.thirdparty.com.google.common.cache.RemovalNotification;
import org.apache.hadoop.util.KMSUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KeyProviderCache {
    public static final Logger LOG = LoggerFactory.getLogger(KeyProviderCache.class);
    private final Cache<URI, KeyProvider> cache;
    public static final int SHUTDOWN_HOOK_PRIORITY = 9;

    public KeyProviderCache(long expiryMs) {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(expiryMs, TimeUnit.MILLISECONDS).removalListener(new RemovalListener<URI, KeyProvider>(){

            @Override
            public void onRemoval(@Nonnull RemovalNotification<URI, KeyProvider> notification) {
                try {
                    assert (notification.getValue() != null);
                    ((KeyProvider)notification.getValue()).close();
                }
                catch (Throwable e) {
                    LOG.error("Error closing KeyProvider with uri [" + notification.getKey() + "]", e);
                }
            }
        }).build();
        if (!ShutdownHookManager.get().isShutdownInProgress()) {
            ShutdownHookManager.get().addShutdownHook(new KeyProviderCacheFinalizer(), 9);
        }
    }

    public KeyProvider get(final Configuration conf, final URI serverProviderUri) {
        if (serverProviderUri == null) {
            return null;
        }
        try {
            return this.cache.get(serverProviderUri, new Callable<KeyProvider>(){

                @Override
                public KeyProvider call() throws Exception {
                    return KMSUtil.createKeyProviderFromUri(conf, serverProviderUri);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Could not create KeyProvider for DFSClient !!", e);
            return null;
        }
    }

    @VisibleForTesting
    synchronized void invalidateCache() {
        LOG.debug("Invalidating all cached KeyProviders.");
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
    }

    private URI createKeyProviderURI(Configuration conf) {
        URI providerUri;
        String providerUriStr = conf.getTrimmed("hadoop.security.key.provider.path");
        if (providerUriStr == null || providerUriStr.isEmpty()) {
            LOG.error("Could not find uri with key [hadoop.security.key.provider.path] to create a keyProvider !!");
            return null;
        }
        try {
            providerUri = new URI(providerUriStr);
        }
        catch (URISyntaxException e) {
            LOG.error("KeyProvider URI string is invalid [" + providerUriStr + "]!!", e.getCause());
            return null;
        }
        return providerUri;
    }

    @VisibleForTesting
    public void setKeyProvider(Configuration conf, KeyProvider keyProvider) {
        URI uri = this.createKeyProviderURI(conf);
        assert (uri != null);
        this.cache.put(uri, keyProvider);
    }

    private class KeyProviderCacheFinalizer
    implements Runnable {
        private KeyProviderCacheFinalizer() {
        }

        @Override
        public synchronized void run() {
            KeyProviderCache.this.invalidateCache();
        }
    }
}

