/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;

final class EvaluatingStatisticsMap<E extends Serializable>
implements Map<String, E> {
    private final Map<String, Function<String, E>> evaluators = new ConcurrentHashMap<String, Function<String, E>>();
    private final Function<E, E> copyFn;

    EvaluatingStatisticsMap() {
        this(IOStatisticsBinding::passthroughFn);
    }

    EvaluatingStatisticsMap(Function<E, E> copyFn) {
        this.copyFn = copyFn;
    }

    void addFunction(String key, Function<String, E> eval) {
        this.evaluators.put(key, eval);
    }

    @Override
    public int size() {
        return this.evaluators.size();
    }

    @Override
    public boolean isEmpty() {
        return this.evaluators.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.evaluators.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(Object key) {
        Function<String, E> fn = this.evaluators.get(key);
        return (E)(fn != null ? (Serializable)fn.apply((String)key) : null);
    }

    @Override
    public E put(String key, E value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends E> m4) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return this.evaluators.keySet();
    }

    @Override
    public Collection<E> values() {
        Set<Map.Entry<String, Function<String, E>>> evalEntries = this.evaluators.entrySet();
        return evalEntries.parallelStream().map(e -> (Serializable)((Function)e.getValue()).apply(e.getKey())).collect(Collectors.toList());
    }

    public Map<String, E> snapshot() {
        return IOStatisticsBinding.snapshotMap(this, this.copyFn);
    }

    @Override
    public synchronized Set<Map.Entry<String, E>> entrySet() {
        Set<Map.Entry<String, Function<String, E>>> evalEntries = this.evaluators.entrySet();
        Set<Map.Entry<String, E>> r = evalEntries.parallelStream().map(e -> new EntryImpl((String)e.getKey(), ((Function)e.getValue()).apply(e.getKey()))).collect(Collectors.toSet());
        return r;
    }

    private static final class EntryImpl<E>
    implements Map.Entry<String, E> {
        private String key;
        private E value;

        private EntryImpl(String key, E value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public E setValue(E val) {
            this.value = val;
            return val;
        }
    }
}

