/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.util.functional.RunnableRaisingIOE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakReporter
implements Closeable {
    public static final String RESOURCE_LEAKS_LOG_NAME = "org.apache.hadoop.fs.resource.leaks";
    private static final Logger LEAK_LOG = LoggerFactory.getLogger("org.apache.hadoop.fs.resource.leaks");
    @VisibleForTesting
    static final String THREAD_FORMAT = "; thread: %s; id: %d";
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final BooleanSupplier isOpen;
    private final RunnableRaisingIOE closeAction;
    private final IOException leakException;

    public LeakReporter(String message, BooleanSupplier isOpen, RunnableRaisingIOE closeAction) {
        this.isOpen = Objects.requireNonNull(isOpen);
        this.closeAction = Objects.requireNonNull(closeAction);
        this.leakException = new IOException(message + String.format(THREAD_FORMAT, Thread.currentThread().getName(), Thread.currentThread().getId()));
    }

    @Override
    public void close() {
        try {
            if (!this.closed.getAndSet(true) && this.isOpen.getAsBoolean()) {
                LEAK_LOG.warn(this.leakException.getMessage());
                LEAK_LOG.info("stack", this.leakException);
                this.closeAction.apply();
            }
        }
        catch (Exception e) {
            LEAK_LOG.info("executing leak cleanup actions", e);
        }
    }

    public IOException getLeakException() {
        return this.leakException;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public String toString() {
        return "LeakReporter{closed=" + this.closed.get() + '}';
    }
}

