/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.EventLoopTaskQueueFactory;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventArray;
import io.netty.channel.kqueue.Native;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.util.IntSupplier;
import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.LongObjectMap;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class KQueueEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KQueueEventLoop.class);
    private static final AtomicIntegerFieldUpdater<KQueueEventLoop> WAKEN_UP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(KQueueEventLoop.class, "wakenUp");
    private static final int KQUEUE_WAKE_UP_IDENT = 0;
    private static final int KQUEUE_MAX_TIMEOUT_SECONDS = 86399;
    private final boolean allowGrowing;
    private final FileDescriptor kqueueFd;
    private final KQueueEventArray changeList;
    private final KQueueEventArray eventList;
    private final SelectStrategy selectStrategy;
    private final IovArray iovArray = new IovArray();
    private final IntSupplier selectNowSupplier = new IntSupplier(){

        @Override
        public int get() throws Exception {
            return KQueueEventLoop.this.kqueueWaitNow();
        }
    };
    private final LongObjectMap<KQueueRegistration> registrations = new LongObjectHashMap<KQueueRegistration>(4096);
    private final Queue<KQueueRegistration> cancelledRegistrations = new ArrayDeque<KQueueRegistration>();
    private long nextId;
    private volatile int wakenUp;
    private volatile int ioRatio = 50;

    KQueueEventLoop(EventLoopGroup parent, Executor executor, int maxEvents, SelectStrategy strategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory taskQueueFactory, EventLoopTaskQueueFactory tailTaskQueueFactory) {
        super(parent, executor, false, KQueueEventLoop.newTaskQueue(taskQueueFactory), KQueueEventLoop.newTaskQueue(tailTaskQueueFactory), rejectedExecutionHandler);
        this.selectStrategy = ObjectUtil.checkNotNull(strategy, "strategy");
        this.kqueueFd = Native.newKQueue();
        if (maxEvents == 0) {
            this.allowGrowing = true;
            maxEvents = 4096;
        } else {
            this.allowGrowing = false;
        }
        this.changeList = new KQueueEventArray(maxEvents);
        this.eventList = new KQueueEventArray(maxEvents);
        int result = Native.keventAddUserEvent(this.kqueueFd.intValue(), 0);
        if (result < 0) {
            this.cleanup();
            throw new IllegalStateException("kevent failed to add user event with errno: " + -result);
        }
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory queueFactory) {
        if (queueFactory == null) {
            return KQueueEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return queueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    private long generateNextId() {
        boolean reset = false;
        do {
            if (this.nextId == Long.MAX_VALUE) {
                if (reset) {
                    throw new IllegalStateException("All possible ids in use");
                }
                reset = true;
            }
            ++this.nextId;
        } while (this.nextId == 0L || this.registrations.containsKey(this.nextId));
        return this.nextId;
    }

    private void processCancelledRegistrations() {
        KQueueRegistration cancelledRegistration;
        KQueueRegistration removed;
        while (true) {
            if ((cancelledRegistration = this.cancelledRegistrations.poll()) == null) {
                return;
            }
            removed = this.registrations.remove(cancelledRegistration.id);
            assert (removed == cancelledRegistration);
        }
    }

    KQueueRegistration add(AbstractKQueueChannel ch) {
        assert (this.inEventLoop());
        long id = this.generateNextId();
        KQueueRegistration registration = new KQueueRegistration(ch, id);
        KQueueRegistration old = this.registrations.put(id, registration);
        assert (old == null);
        return registration;
    }

    IovArray cleanArray() {
        this.iovArray.clear();
        return this.iovArray;
    }

    @Override
    protected void wakeup(boolean inEventLoop) {
        if (!inEventLoop && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
            this.wakeup();
        }
    }

    private void wakeup() {
        Native.keventTriggerUserEvent(this.kqueueFd.intValue(), 0);
    }

    private int kqueueWait(boolean oldWakeup) throws IOException {
        if (oldWakeup && this.hasTasks()) {
            return this.kqueueWaitNow();
        }
        long totalDelay = this.delayNanos(System.nanoTime());
        int delaySeconds = (int)Math.min(totalDelay / 1000000000L, 86399L);
        int delayNanos = (int)(totalDelay % 1000000000L);
        return this.kqueueWait(delaySeconds, delayNanos);
    }

    private int kqueueWaitNow() throws IOException {
        return this.kqueueWait(0, 0);
    }

    private int kqueueWait(int timeoutSec, int timeoutNs) throws IOException {
        int numEvents = Native.keventWait(this.kqueueFd.intValue(), this.changeList, this.eventList, timeoutSec, timeoutNs);
        this.changeList.clear();
        return numEvents;
    }

    private void processReady(int ready) {
        for (int i = 0; i < ready; ++i) {
            short filter = this.eventList.filter(i);
            short flags = this.eventList.flags(i);
            int fd = this.eventList.fd(i);
            if (filter == Native.EVFILT_USER || (flags & Native.EV_ERROR) != 0) {
                assert (filter != Native.EVFILT_USER || filter == Native.EVFILT_USER && fd == 0);
                continue;
            }
            long id = this.eventList.udata(i);
            KQueueRegistration registration = this.registrations.get(id);
            if (registration == null) {
                logger.warn("events[{}]=[{}, {}, {}] had no registration!", i, fd, id, filter);
                continue;
            }
            if (registration.removed) continue;
            AbstractKQueueChannel.AbstractKQueueUnsafe unsafe = (AbstractKQueueChannel.AbstractKQueueUnsafe)registration.channel.unsafe();
            if (filter == Native.EVFILT_WRITE) {
                unsafe.writeReady();
            } else if (filter == Native.EVFILT_READ) {
                unsafe.readReady(this.eventList.data(i));
            } else if (filter == Native.EVFILT_SOCK && (this.eventList.fflags(i) & Native.NOTE_RDHUP) != 0) {
                unsafe.readEOF();
            }
            if ((flags & Native.EV_EOF) == 0) continue;
            unsafe.readEOF();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void run() {
        block29: while (true) {
            try {
                strategy = this.selectStrategy.calculateStrategy(this.selectNowSupplier, this.hasTasks());
                switch (strategy) {
                    ** case -2:
lbl6:
                    // 1 sources

                    continue block29;
                    case -3: 
                    case -1: {
                        strategy = this.kqueueWait(KQueueEventLoop.WAKEN_UP_UPDATER.getAndSet(this, 0) == 1);
                        if (this.wakenUp == 1) {
                            this.wakeup();
                        }
                    }
                    default: {
                        ioRatio = this.ioRatio;
                        if (ioRatio != 100) ** GOTO lbl22
                        try {
                            if (strategy <= 0) ** GOTO lbl32
                            this.processReady(strategy);
                        }
                        finally {
                            this.runAllTasks();
                        }
lbl22:
                        // 1 sources

                        ioStartTime = System.nanoTime();
                        try {
                            if (strategy > 0) {
                                this.processReady(strategy);
                            }
                        }
                        finally {
                            ioTime = System.nanoTime() - ioStartTime;
                            this.runAllTasks(ioTime * (long)(100 - ioRatio) / (long)ioRatio);
                        }
lbl32:
                        // 3 sources

                        if (!this.allowGrowing || strategy != this.eventList.capacity()) continue block29;
                        this.eventList.realloc(false);
                        continue block29;
                    }
                }
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                KQueueEventLoop.handleLoopException(t);
                continue;
            }
            finally {
                this.processCancelledRegistrations();
                try {
                    if (!this.isShuttingDown()) continue;
                    this.closeAll();
                    if (!this.confirmShutdown()) continue;
                    break;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable t) {
                    KQueueEventLoop.handleLoopException(t);
                }
                continue;
            }
            break;
        }
    }

    @Override
    protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
        return KQueueEventLoop.newTaskQueue0(maxPendingTasks);
    }

    private static Queue<Runnable> newTaskQueue0(int maxPendingTasks) {
        return maxPendingTasks == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue(maxPendingTasks);
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(int ioRatio) {
        if (ioRatio <= 0 || ioRatio > 100) {
            throw new IllegalArgumentException("ioRatio: " + ioRatio + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = ioRatio;
    }

    @Override
    public int registeredChannels() {
        return this.registrations.size();
    }

    @Override
    public Iterator<Channel> registeredChannelsIterator() {
        assert (this.inEventLoop());
        final LongObjectMap<KQueueRegistration> ch = this.registrations;
        if (ch.isEmpty()) {
            return SingleThreadEventLoop.ChannelsReadOnlyIterator.empty();
        }
        return new SingleThreadEventLoop.ChannelsReadOnlyIterator<AbstractKQueueChannel>(new Iterable<AbstractKQueueChannel>(){
            private final Collection<KQueueRegistration> registrations;
            {
                this.registrations = ch.values();
            }

            @Override
            public Iterator<AbstractKQueueChannel> iterator() {
                final Iterator<KQueueRegistration> registrationIterator = this.registrations.iterator();
                return new Iterator<AbstractKQueueChannel>(){

                    @Override
                    public boolean hasNext() {
                        return registrationIterator.hasNext();
                    }

                    @Override
                    public AbstractKQueueChannel next() {
                        return ((KQueueRegistration)registrationIterator.next()).channel;
                    }
                };
            }
        });
    }

    @Override
    protected void cleanup() {
        try {
            try {
                this.kqueueFd.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the kqueue fd.", e);
            }
        }
        finally {
            this.iovArray.release();
            this.changeList.free();
            this.eventList.free();
        }
    }

    private void closeAll() {
        KQueueRegistration[] localRegistrations;
        try {
            this.kqueueWaitNow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (KQueueRegistration reg : localRegistrations = this.registrations.values().toArray(new KQueueRegistration[0])) {
            reg.channel.unsafe().close(reg.channel.unsafe().voidPromise());
        }
        this.processCancelledRegistrations();
    }

    private static void handleLoopException(Throwable t2) {
        logger.warn("Unexpected exception in the selector loop.", t2);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        KQueue.ensureAvailability();
    }

    final class KQueueRegistration {
        private final AbstractKQueueChannel channel;
        private final long id;
        private boolean removed;

        KQueueRegistration(AbstractKQueueChannel channel, long id) {
            this.channel = channel;
            this.id = id;
        }

        void evSet(short filter, short flags, int fflags, long data) {
            assert (KQueueEventLoop.this.inEventLoop());
            if (this.removed) {
                return;
            }
            KQueueEventLoop.this.changeList.evSet(this.channel.fd().intValue(), filter, flags, fflags, data, this.id);
        }

        void remove() throws Exception {
            assert (KQueueEventLoop.this.inEventLoop());
            KQueueRegistration old = (KQueueRegistration)KQueueEventLoop.this.registrations.get(this.id);
            if (old == null) {
                return;
            }
            assert (old == this);
            if (!old.removed) {
                KQueueEventLoop.this.cancelledRegistrations.offer(old);
            }
            if (this.channel.isOpen()) {
                this.channel.unregisterFilters();
            }
            old.removed = true;
        }
    }
}

