/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.hadoop.impl.IndexedInputSplit;
import com.hazelcast.jet.hadoop.impl.ReadHadoopNewApiP;
import com.hazelcast.jet.hadoop.impl.ReadHdfsMetaSupplierBase;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.file.impl.FileTraverser;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public final class ReadHadoopOldApiP<K, V, R>
extends AbstractProcessor {
    private final HadoopFileTraverser<K, V, R> traverser;

    private ReadHadoopOldApiP(@Nonnull JobConf jobConf, @Nonnull List<InputSplit> splits, @Nonnull BiFunctionEx<K, V, R> projectionFn) {
        this.traverser = new HadoopFileTraverser<K, V, R>(jobConf, splits, projectionFn);
    }

    public boolean isCooperative() {
        return false;
    }

    public boolean complete() {
        return this.emitFromTraverser((Traverser)this.traverser);
    }

    public void close() throws Exception {
        this.traverser.close();
    }

    private static <K, V> InputSplit[] getSplits(JobConf jobConf, int numSplits) throws IOException {
        InputFormat inputFormat = jobConf.getInputFormat();
        try {
            return inputFormat.getSplits(jobConf, numSplits);
        }
        catch (InvalidInputException e) {
            String directory = jobConf.get("mapreduce.input.fileinputformat.inputdir", "");
            boolean ignoreFileNotFound = jobConf.getBoolean("jet.source.ignorefilenotfound", true);
            if (ignoreFileNotFound) {
                ILogger logger = Logger.getLogger(ReadHadoopNewApiP.class);
                logger.fine("The directory '%s' does not exist. This source will emit 0 items.", (Object)directory);
                return new InputSplit[0];
            }
            throw new JetException("The input " + directory + " matches no files");
        }
    }

    private static boolean shouldSplitOnMembers(JobConf jobConf) {
        if (jobConf.getBoolean("jet.source.sharedlocalfs", false)) {
            return false;
        }
        Path[] inputPaths = FileInputFormat.getInputPaths(jobConf);
        boolean hasLocalFileSystem = false;
        boolean hasRemoteFileSystem = false;
        for (Path inputPath : inputPaths) {
            if (ReadHadoopOldApiP.isLocalFileSystem(inputPath, jobConf)) {
                hasLocalFileSystem = true;
                continue;
            }
            hasRemoteFileSystem = true;
        }
        if (hasLocalFileSystem && hasRemoteFileSystem) {
            throw new IllegalArgumentException("LocalFileSystem should be marked as shared when used with other remote file systems");
        }
        return hasLocalFileSystem;
    }

    private static boolean isLocalFileSystem(Path inputPath, JobConf jobConf) {
        FileSystem fileSystem = (FileSystem)Util.uncheckCall(() -> inputPath.getFileSystem(jobConf));
        return fileSystem instanceof LocalFileSystem || fileSystem instanceof RawLocalFileSystem;
    }

    private static final class HadoopFileTraverser<K, V, R>
    implements FileTraverser<R> {
        private final JobConf jobConf;
        private final InputFormat<K, V> inputFormat;
        private final BiFunctionEx<K, V, R> projectionFn;
        private final Traverser<R> delegate;
        private RecordReader<K, V> reader;

        private HadoopFileTraverser(JobConf jobConf, List<InputSplit> splits, BiFunctionEx<K, V, R> projectionFn) {
            this.jobConf = jobConf;
            this.inputFormat = jobConf.getInputFormat();
            this.projectionFn = projectionFn;
            this.delegate = Traversers.traverseIterable(splits).flatMap(this::traverseSplit);
        }

        private Traverser<R> traverseSplit(InputSplit inputSplit) {
            this.reader = (RecordReader)Util.uncheckCall(() -> this.inputFormat.getRecordReader(inputSplit, this.jobConf, Reporter.NULL));
            return () -> Util.uncheckCall(() -> {
                K key = this.reader.createKey();
                V value = this.reader.createValue();
                while (this.reader.next(key, value)) {
                    Object projectedRecord = this.projectionFn.apply(key, value);
                    if (projectedRecord == null) continue;
                    return projectedRecord;
                }
                this.reader.close();
                return null;
            });
        }

        public R next() {
            return (R)this.delegate.next();
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    private static final class Supplier<K, V, R>
    implements ProcessorSupplier {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final JobConf jobConf;
        private final BiFunctionEx<K, V, R> projectionFn;
        private final List<IndexedInputSplit> assignedSplits;

        private Supplier(@Nonnull JobConf jobConf, @Nonnull List<IndexedInputSplit> assignedSplits, @Nonnull BiFunctionEx<K, V, R> projectionFn) {
            this.jobConf = jobConf;
            this.projectionFn = projectionFn;
            this.assignedSplits = assignedSplits;
        }

        @Nonnull
        public List<Processor> get(int count) {
            List inputSplits = ReadHadoopOldApiP.shouldSplitOnMembers(this.jobConf) ? (List)Util.uncheckCall(() -> Arrays.asList(ReadHadoopOldApiP.getSplits(this.jobConf, count))) : this.assignedSplits.stream().map(IndexedInputSplit::getOldSplit).collect(Collectors.toList());
            return Util.distributeObjects((int)count, inputSplits).values().stream().map(splits -> new ReadHadoopOldApiP<K, V, R>(this.jobConf, (List<InputSplit>)splits, this.projectionFn)).collect(Collectors.toList());
        }
    }

    public static class MetaSupplier<K, V, R>
    extends ReadHdfsMetaSupplierBase<R> {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final JobConf jobConf;
        private final BiFunctionEx<K, V, R> projectionFn;
        private transient Map<Address, List<IndexedInputSplit>> assigned;

        public MetaSupplier(@Nonnull JobConf jobConf, @Nonnull BiFunctionEx<K, V, R> projectionFn) {
            this.jobConf = jobConf;
            this.projectionFn = projectionFn;
        }

        @Override
        public void init(@Nonnull ProcessorMetaSupplier.Context context) throws Exception {
            super.init(context);
            if (ReadHadoopOldApiP.shouldSplitOnMembers(this.jobConf)) {
                this.assigned = new HashMap<Address, List<IndexedInputSplit>>();
            } else {
                int totalParallelism = context.totalParallelism();
                InputSplit[] splits = ReadHadoopOldApiP.getSplits(this.jobConf, totalParallelism);
                IndexedInputSplit[] indexedInputSplits = new IndexedInputSplit[splits.length];
                Arrays.setAll(indexedInputSplits, i -> new IndexedInputSplit(i, splits[i]));
                Address[] addresses = (Address[])context.partitionAssignment().keySet().toArray(Address[]::new);
                this.assigned = this.assignSplitsToMembers(indexedInputSplits, addresses);
                this.printAssignments(this.assigned);
            }
        }

        @Nonnull
        public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            return address -> new Supplier<K, V, R>(this.jobConf, this.assigned.getOrDefault(address, Collections.emptyList()), this.projectionFn);
        }

        public FileTraverser<R> traverser() throws Exception {
            return new HadoopFileTraverser<K, V, R>(this.jobConf, Arrays.asList(ReadHadoopOldApiP.getSplits(this.jobConf, 1)), this.projectionFn);
        }

        public boolean closeIsCooperative() {
            return true;
        }
    }
}

