/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.ssl;

import com.hazelcast.webmonitor.config.properties.SSLProperties;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.util.ResourceUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SSLContextFactory {
    private SSLContextFactory() {
    }

    public static SSLContext createSSLContext(SSLProperties sslProperties) throws Exception {
        SSLContext sslContext = SSLContext.getInstance(sslProperties.getProtocol());
        KeyManagerFactory kmf = SSLContextFactory.loadKeyManagerFactory((SSLProperties)sslProperties);
        TrustManagerFactory tmf = SSLContextFactory.loadTrustManagerFactory((SSLProperties)sslProperties);
        KeyManager[] keyManagers = kmf == null ? null : kmf.getKeyManagers();
        TrustManager[] trustManagers = tmf == null ? null : tmf.getTrustManagers();
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    private static KeyManagerFactory loadKeyManagerFactory(SSLProperties sslProperties) throws Exception {
        if (sslProperties.getKeyStore() == null) {
            return null;
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(sslProperties.getKeyManagerAlgorithm());
        char[] passPhrase = Optional.ofNullable(sslProperties.getKeyStorePassword()).map(String::toCharArray).orElse(null);
        KeyStore ks = KeyStore.getInstance(sslProperties.getKeyStoreType());
        try (FileInputStream fis = new FileInputStream(ResourceUtils.getFile((String)sslProperties.getKeyStore()));){
            ks.load(fis, passPhrase);
        }
        kmf.init(ks, passPhrase);
        return kmf;
    }

    private static TrustManagerFactory loadTrustManagerFactory(SSLProperties sslProperties) throws Exception {
        if (sslProperties.getTrustStore() == null) {
            return null;
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(sslProperties.getTrustManagerAlgorithm());
        char[] passPhrase = Optional.ofNullable(sslProperties.getTrustStorePassword()).map(String::toCharArray).orElse(null);
        KeyStore ts = KeyStore.getInstance(sslProperties.getTrustStoreType());
        try (FileInputStream fis = new FileInputStream(ResourceUtils.getFile((String)sslProperties.getTrustStore()));){
            ts.load(fis, passPhrase);
        }
        tmf.init(ts);
        return tmf;
    }
}

