/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.sql.rest;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.webmonitor.controller.dto.SqlQueryDTO;
import com.hazelcast.webmonitor.service.MapManager;
import com.hazelcast.webmonitor.service.client.MCMapConfig;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import com.hazelcast.webmonitor.sql.SqlManager;
import com.hazelcast.webmonitor.sql.dto.ColumnDTO;
import com.hazelcast.webmonitor.sql.dto.IndexDTO;
import com.hazelcast.webmonitor.sql.dto.MappingDTO;
import com.hazelcast.webmonitor.sql.dto.MappingSuggestionDTO;
import com.hazelcast.webmonitor.sql.dto.QueryHistoryDTO;
import com.hazelcast.webmonitor.sql.dto.SQLTaskInfoDTO;
import com.hazelcast.webmonitor.sql.dto.SqlResultDTO;
import com.hazelcast.webmonitor.sql.dto.TableDTO;
import com.hazelcast.webmonitor.utils.SecurityContextUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/clusters/{cluster}/sql"})
@Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
public class SqlController {
    private final SqlManager sqlManager;
    private final MapManager mapManager;
    private final MemberConfigService configService;

    @PostMapping
    public SqlResultDTO sqlExecute(@PathVariable String cluster, @RequestBody SqlQueryDTO sql) {
        return this.sqlManager.execute(SecurityContextUtil.getUsername(), cluster, sql);
    }

    @PostMapping(path={"queries/{queryId}/pause"})
    public void pauseStreamingQuery(@PathVariable String queryId) {
        this.sqlManager.pauseStreamingQuery(queryId);
    }

    @PostMapping(path={"queries/{queryId}/resume"})
    public void resumeStreamingQuery(@PathVariable String queryId) {
        this.sqlManager.resumeStreamingQuery(queryId);
    }

    @GetMapping(path={"/history"})
    public List<QueryHistoryDTO> queryHistory(@PathVariable String cluster) {
        return this.sqlManager.history(SecurityContextUtil.getUsername(), cluster);
    }

    @GetMapping(path={"/tables"})
    public List<TableDTO> getTables(@PathVariable String cluster) {
        List mappings = this.sqlManager.getMappings(cluster);
        List views = this.sqlManager.getViews(cluster);
        return Stream.concat(views.stream().map(view -> TableDTO.builder().name(view.getName()).type(TableDTO.Type.VIEW).build()), mappings.stream().map(it -> TableDTO.builder().name(it.getName()).type(TableDTO.Type.MAPPING).connector(it.getType()).build())).collect(Collectors.toList());
    }

    @GetMapping(path={"/mapping-suggestions/{iMapName}"})
    public MappingSuggestionDTO getCreateMappingSuggestionForIMap(@PathVariable String cluster, @PathVariable String iMapName) {
        String suggestion = this.sqlManager.getCreateMappingSuggestionForIMap(cluster, iMapName);
        return new MappingSuggestionDTO(suggestion);
    }

    @GetMapping(path={"/tables/{tableName}"})
    public TableDTO getTableSchema(@PathVariable String cluster, @PathVariable String tableName) {
        TableDTO result = this.sqlManager.getTable(cluster, tableName);
        List columns = this.sqlManager.getTableColumns(cluster, tableName);
        result.setColumns(columns);
        if (result.getType() == TableDTO.Type.MAPPING) {
            MappingDTO mapping = this.sqlManager.getMapping(cluster, tableName);
            result.setExternalName(mapping.getExternalName());
            result.setIndexes(this.getMapIndexes(cluster, mapping.getExternalName(), columns));
        }
        return result;
    }

    @GetMapping(path={"/tasks"})
    public List<SQLTaskInfoDTO> getSqlTasks(@PathVariable String cluster) {
        return this.sqlManager.getSqlTasks(cluster);
    }

    private List<IndexDTO> getMapIndexes(String cluster, String mapName, List<ColumnDTO> columns) {
        MCMapConfig mapConfig = this.mapManager.getMapConfig(cluster, mapName);
        List indexes = mapConfig.getGlobalIndexes();
        if (this.globalIndexesUsed(cluster, mapConfig) && !CollectionUtils.isEmpty((Collection)indexes)) {
            Map<String, String> externalNames = columns.stream().collect(Collectors.toMap(column -> column.getExternalName().replaceFirst("this.", ""), ColumnDTO::getName));
            return indexes.stream().filter(index -> externalNames.keySet().containsAll(index.getAttributes())).map(index -> this.convertToIndexDTO(externalNames, index)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean globalIndexesUsed(String cluster, MCMapConfig mapConfig) {
        if (mapConfig.getInMemoryFormat() != InMemoryFormat.NATIVE) {
            return true;
        }
        return this.configService.getRandomConfigFromCluster(cluster).map(MemberConfig::toEffectiveConfig).map(config -> config.getProperty(ClusterProperty.GLOBAL_HD_INDEX_ENABLED.toString())).map(Boolean::parseBoolean).orElse(false);
    }

    private IndexDTO convertToIndexDTO(Map<String, String> externalNames, IndexConfig index) {
        List updatedAttributes = index.getAttributes().stream().map(externalNames::get).collect(Collectors.toList());
        return new IndexDTO(index.getName(), index.getType().name(), updatedAttributes);
    }

    @ConstructorProperties(value={"sqlManager", "mapManager", "configService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SqlController(SqlManager sqlManager, MapManager mapManager, MemberConfigService configService) {
        this.sqlManager = sqlManager;
        this.mapManager = mapManager;
        this.configService = configService;
    }
}

