/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.wan;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConsistencyCheckStrategy;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.webmonitor.controller.dto.wan.MapWithWanReplicationDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.service.MapManager;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import com.hazelcast.webmonitor.utils.InternalObjectsUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class WanReplicationConfigService {
    private final MapManager mapManager;
    private final MemberConfigService memberConfigService;

    public static String identifierOfWanPublisher(WanBatchPublisherConfig config) {
        return config.getPublisherId() == null || "".equals(config.getPublisherId().trim()) ? config.getClusterName() : config.getPublisherId();
    }

    public List<MapWithWanReplicationDTO> getWanReplicatedMaps(AllState state, String cluster, String replication) {
        return state.getMemberStates().stream().map(MemberState::getMaps).flatMap(Collection::stream).distinct().filter(mapName -> {
            WanReplicationRef wanReplicationRef = this.mapManager.getWanReplicationOfMap(cluster, mapName);
            return wanReplicationRef != null && wanReplicationRef.getName().equals(replication);
        }).map(mapName -> new MapWithWanReplicationDTO(mapName, InternalObjectsUtil.isInternalObject((String)mapName))).toList();
    }

    public Map<String, ConsistencyCheckStrategy> getConsistencyCheckStrategiesPerPublisher(AllState state, String cluster, String replication) {
        List memberConfigs = this.getHazelcastMemberConfigs(state, cluster);
        if (memberConfigs.isEmpty()) {
            return Collections.emptyMap();
        }
        return memberConfigs.stream().map(config -> config.getWanReplicationConfig(replication)).filter(Objects::nonNull).map(WanReplicationConfig::getBatchPublisherConfigs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toMap(WanReplicationConfigService::identifierOfWanPublisher, it -> it.getSyncConfig().getConsistencyCheckStrategy()));
    }

    private List<Config> getHazelcastMemberConfigs(AllState state, String cluster) {
        return state.getMembers().stream().map(memberAddress -> MemberIdentifier.of((String)cluster, (String)memberAddress)).map(arg_0 -> ((MemberConfigService)this.memberConfigService).getMemberConfig(arg_0)).filter(Objects::nonNull).map(MemberConfig::toEffectiveConfig).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"mapManager", "memberConfigService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WanReplicationConfigService(MapManager mapManager, MemberConfigService memberConfigService) {
        this.mapManager = mapManager;
        this.memberConfigService = memberConfigService;
    }
}

