/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.memberconfig;

import com.hazelcast.webmonitor.service.SettingsService;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import com.hazelcast.webmonitor.utils.XmlUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public final class MemberConfigFactory {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemberConfigFactory.class);
    private static final String SENSITIVE_CONFIG_MASK = "1";
    private final SettingsService settingsService;

    public MemberConfig createMemberConfig(String rawXml) {
        List maskedConfigProperties = this.settingsService.getMaskedConfigProperties();
        if (!maskedConfigProperties.isEmpty()) {
            try {
                String processedXml = XmlUtil.maskXPathExpressionsInXml((String)rawXml, (String)SENSITIVE_CONFIG_MASK, (List)maskedConfigProperties);
                MemberConfig result = new MemberConfig(processedXml);
                result.toEffectiveConfig();
                return result;
            }
            catch (Exception e) {
                log.warn("Can't mask member config properties. Saving the raw configuration. Error: {}", (Object)e.getMessage());
            }
        }
        return new MemberConfig(rawXml);
    }

    @ConstructorProperties(value={"settingsService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MemberConfigFactory(SettingsService settingsService) {
        this.settingsService = settingsService;
    }
}

