/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jet;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.cluster.Member;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.JobAndSqlSummary;
import com.hazelcast.jet.impl.JobExecutionRecord;
import com.hazelcast.jet.impl.JobRecord;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.JobResult;
import com.hazelcast.webmonitor.controller.dto.jet.ActiveJobStatsDTO;
import com.hazelcast.webmonitor.controller.dto.jet.ExportedJobSnapshotDTO;
import com.hazelcast.webmonitor.controller.dto.jet.JobInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.JobStatsDTO;
import com.hazelcast.webmonitor.controller.dto.jet.MinimizedJobInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.SnapshotDetailsDTO;
import com.hazelcast.webmonitor.controller.dto.jet.TaskCountsDTO;
import com.hazelcast.webmonitor.metrics.jet.JetClusterMetricsStore;
import com.hazelcast.webmonitor.metrics.jet.TimeSeriesSlice;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpression;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpressions;
import com.hazelcast.webmonitor.metrics.jet.tsdb.TimeSeries;
import com.hazelcast.webmonitor.metrics.utils.TimeUtil;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.jet.BaseJetManager;
import com.hazelcast.webmonitor.service.jet.JetMetricsService;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
class JobManager
extends BaseJetManager {
    JobManager(MCClientManager clientManager, JetMetricsService jetMetricsService, Clock clock) {
        super(clientManager, jetMetricsService, clock);
    }

    List<MinimizedJobInfoDTO> getJobs(String cluster) {
        JetClusterMetricsStore store = this.jetMetricsService.getStore(cluster);
        MCClient client = this.clientFor(cluster);
        return client.getJobSummaryList().stream().filter(jobSummary -> !jobSummary.isLightJob()).map(summary -> this.toMinimizedJobInfo(store, summary)).collect(Collectors.toList());
    }

    JobInfoDTO getJobInfo(String cluster, String idString) {
        JobResult jobResult;
        MCClient client = this.clientFor(cluster);
        JobRepository jobRepository = new JobRepository(client.getHzClient());
        BaseJetManager.JobIdentifier jobIdentifier = new BaseJetManager.JobIdentifier(cluster, idString);
        Job job = this.getJob(jobIdentifier);
        JobStatus status = job.getStatus();
        JobConfig jobConfig = job.getConfig();
        String lastExecutionId = this.getLastExecutionId(jobIdentifier);
        JobInfoDTO.JobInfoDTOBuilder builder = JobInfoDTO.builder().id(idString).lastExecutionId(lastExecutionId).name(job.getName()).status(status).config(jobConfig).submissionTime(job.getSubmissionTime()).processingGuarantee(jobConfig.getProcessingGuarantee());
        if (this.isSuspended(job.getStatus())) {
            builder.suspensionCause(job.getSuspensionCause().toString());
        }
        if ((jobResult = jobRepository.getJobResult(job.getId())) != null) {
            builder.completionTime(jobResult.getCompletionTime());
        }
        ActiveJobStatsDTO jobStats = this.isActive(job) ? this.getJobStats(jobIdentifier, lastExecutionId, status, job.getSubmissionTime()) : ActiveJobStatsDTO.builder().build();
        builder.stats(jobStats);
        if (status == JobStatus.FAILED) {
            builder.failure(jobResult != null ? jobResult.getFailureText() : "Cannot find job failure reason");
            try {
                builder.userCancelled(Boolean.valueOf(job.isUserCancelled()));
            }
            catch (UnsupportedOperationException err) {
                builder.userCancelled(null);
            }
        } else {
            JobRecord jobRecord = jobRepository.getJobRecord(job.getId());
            if (jobRecord != null) {
                builder.dag(this.getDag(jobIdentifier, lastExecutionId, jobRecord));
            }
        }
        builder.snapshotDetails(this.getSnapshotDetails(jobRepository, jobConfig, jobIdentifier));
        return builder.build();
    }

    List<ExportedJobSnapshotDTO> getExportedSnapshots(String cluster) {
        return this.clientFor(cluster).getJobStateSnapshots().stream().map(JobManager::toSnapshotDTO).collect(Collectors.toList());
    }

    TaskCountsDTO getTaskCounts(String cluster) {
        MCClient mcClient = this.clientFor(cluster);
        JetClusterMetricsStore store = this.storeFor(cluster);
        Set members = this.memberUuidsFor(cluster);
        long jobCount = mcClient.getJobSummaryList().stream().filter(arg_0 -> this.isActive(arg_0)).count();
        if (jobCount == 0L) {
            return new TaskCountsDTO(0L, 0L);
        }
        long taskCount = store.query("taskletCount").filter(ts -> members.contains(ts.tags().get("member"))).mapToLong(timeSeries -> timeSeries.queryLast(0L)).sum();
        long nonCooperativeTaskCount = store.query("blockingWorkerCount").filter(ts -> members.contains(ts.tags().get("member"))).mapToLong(timeSeries -> timeSeries.queryLast(0L)).sum();
        return new TaskCountsDTO(taskCount, nonCooperativeTaskCount);
    }

    JobStatsDTO getAggregateJobStats(String cluster, long time) {
        long now = time == 0L ? this.clock.currentTimeMillis() : time;
        JetClusterMetricsStore store = this.storeFor(cluster);
        List emitted = this.getEmittedCounts(store);
        List received = this.getReceivedCounts(store);
        return JobManager.calculateJobStats((long)now, (List)emitted, (List)received);
    }

    private static JobStatsDTO calculateJobStats(long now, List<TimeSeries> emitted, List<TimeSeries> received) {
        long totalIn = JobManager.total(emitted);
        long totalOut = JobManager.total(received);
        long lastMinIn = JobManager.lastMinValue((long)now, emitted, (long)totalIn);
        long lastMinOut = JobManager.lastMinValue((long)now, received, (long)totalOut);
        return new JobStatsDTO(totalIn, totalOut, lastMinIn, lastMinOut);
    }

    private static JobStatsDTO calculateJobStats(long now, List<TimeSeries> emitted, List<TimeSeries> received, long submissionTime) {
        long totalIn = JobManager.total(emitted);
        long totalOut = JobManager.total(received);
        long lastMinIn = JobManager.lastMinValue((long)now, (long)submissionTime, emitted);
        long lastMinOut = JobManager.lastMinValue((long)now, (long)submissionTime, received);
        return new JobStatsDTO(totalIn, totalOut, lastMinIn, lastMinOut);
    }

    private static long lastMinValue(long now, List<TimeSeries> emitted, long totalIn) {
        return totalIn - emitted.stream().mapToLong(ts -> ts.query(now - TimeUtil.ONE_MINUTE_IN_MS, 0L)).sum();
    }

    private static long lastMinValue(long now, long submissionTime, List<TimeSeries> emitted) {
        if (submissionTime >= now - TimeUtil.ONE_MINUTE_IN_MS) {
            return emitted.stream().mapToLong(TimeSeries::queryLast).sum();
        }
        return emitted.stream().mapToLong(ts -> {
            TimeSeriesSlice lastOneMin = ts.queryRange(now - TimeUtil.ONE_MINUTE_IN_MS, now, 0L);
            long[] series = lastOneMin.getSeries();
            long firstValue = JobManager.findFirstNonzero((long[])series);
            ArrayUtils.reverse((long[])series);
            long lastValue = JobManager.findFirstNonzero((long[])series);
            return lastValue - firstValue;
        }).sum();
    }

    private static long total(List<TimeSeries> emitted) {
        return emitted.stream().mapToLong(TimeSeries::queryLast).sum();
    }

    private static ExportedJobSnapshotDTO toSnapshotDTO(JobStateSnapshot snapshot) {
        return ExportedJobSnapshotDTO.builder().name(snapshot.name()).creationTime(snapshot.creationTime()).jobId(Util.idToString((long)snapshot.jobId())).jobName(snapshot.jobName()).payloadSize(snapshot.payloadSize()).build();
    }

    ActiveJobStatsDTO getJobStats(BaseJetManager.JobIdentifier job, String lastExecutionId, JobStatus status, long submissionTime) {
        long now = this.clock.currentTimeMillis();
        JetClusterMetricsStore store = this.storeFor(job);
        List emitted = this.getEmittedCounts(store, job.idString, lastExecutionId);
        List received = this.getReceivedCounts(store, job.idString, lastExecutionId);
        JobStatsDTO jobStats = JobManager.calculateJobStats((long)now, (List)emitted, (List)received, (long)submissionTime);
        if (status.equals((Object)JobStatus.SUSPENDED)) {
            long lastReceivedTime;
            long lastEmittedTime = emitted.stream().mapToLong(TimeSeries::getLatestTime).max().orElse(0L);
            if (lastEmittedTime < now - TimeUtil.ONE_MINUTE_IN_MS) {
                jobStats.setLastMinIn(0L);
            }
            if ((lastReceivedTime = received.stream().mapToLong(TimeSeries::getLatestTime).max().orElse(0L)) < now - TimeUtil.ONE_MINUTE_IN_MS) {
                jobStats.setLastMinOut(0L);
            }
        }
        Set members = this.memberUuidsFor(job.cluster);
        int runningNodeCount = this.getRunningNodeCount(job, lastExecutionId, members);
        return ActiveJobStatsDTO.builder().totalIn(jobStats.getTotalIn()).totalOut(jobStats.getTotalOut()).lastMinIn(jobStats.getLastMinIn()).lastMinOut(jobStats.getLastMinOut()).runningNodeCount(runningNodeCount).totalNodeCount(members.size()).build();
    }

    private int getRunningNodeCount(BaseJetManager.JobIdentifier job, String lastExecutionId, Set<String> memberUuids) {
        return this.storeFor(job).query("queuesSize", (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)job.idString), TagExpressions.tagEquals((String)"exec", (String)lastExecutionId)})).filter(ts -> memberUuids.contains(ts.tags().get("member"))).collect(Collectors.groupingBy(ts -> (String)ts.tags().get("member"))).keySet().size();
    }

    private List<TimeSeries> getReceivedCounts(JetClusterMetricsStore store, String id, String lastExecutionId) {
        if (lastExecutionId == null) {
            return Collections.emptyList();
        }
        return store.query("receivedCount", (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)id), TagExpressions.tagEquals((String)"exec", (String)lastExecutionId), TagExpressions.tagEquals((String)"sink", (String)"true")})).collect(Collectors.toList());
    }

    @VisibleForTesting
    List<TimeSeries> getReceivedCounts(JetClusterMetricsStore store) {
        return store.query("receivedCount", (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"sink", (String)"true")})).collect(Collectors.toList());
    }

    @VisibleForTesting
    List<TimeSeries> getEmittedCounts(JetClusterMetricsStore store, String id, String lastExecutionId) {
        if (lastExecutionId == null) {
            return Collections.emptyList();
        }
        return store.query("emittedCount", (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)id), TagExpressions.tagEquals((String)"exec", (String)lastExecutionId), TagExpressions.tagNotEquals((String)"ordinal", (String)"snapshot"), TagExpressions.tagEquals((String)"source", (String)"true")})).collect(Collectors.toList());
    }

    @VisibleForTesting
    List<TimeSeries> getEmittedCounts(JetClusterMetricsStore store) {
        return store.query("emittedCount", (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagNotEquals((String)"ordinal", (String)"snapshot"), TagExpressions.tagEquals((String)"source", (String)"true")})).collect(Collectors.toList());
    }

    private Set<String> memberUuidsFor(String cluster) {
        return this.clientFor(cluster).getHzClient().getCluster().getMembers().stream().map(Member::getUuid).map(UUID::toString).collect(Collectors.toSet());
    }

    private SnapshotDetailsDTO getSnapshotDetails(JobRepository jobRepository, JobConfig jobConfig, BaseJetManager.JobIdentifier job) {
        ProcessingGuarantee processingGuarantee = jobConfig.getProcessingGuarantee();
        SnapshotDetailsDTO.SnapshotDetailsDTOBuilder builder = SnapshotDetailsDTO.builder();
        if (processingGuarantee == ProcessingGuarantee.AT_LEAST_ONCE || processingGuarantee == ProcessingGuarantee.EXACTLY_ONCE) {
            builder.snapshotIntervalMillis(jobConfig.getSnapshotIntervalMillis());
            JobExecutionRecord executionRecord = jobRepository.getJobExecutionRecord(job.id);
            if (executionRecord != null) {
                JobExecutionRecord.SnapshotStats snapshotStats = executionRecord.snapshotStats();
                if (this.isSnapshotSuccessful(executionRecord) && snapshotStats != null) {
                    builder.lastSnapshotKeys(snapshotStats.numKeys());
                    builder.lastSnapshotSize(snapshotStats.numBytes());
                    builder.lastSnapshotTime(snapshotStats.endTime());
                    builder.lastSnapshotDuration(snapshotStats.duration());
                }
            }
        }
        return builder.build();
    }

    private boolean isSnapshotSuccessful(JobExecutionRecord executionRecord) {
        return executionRecord.lastSnapshotFailure() == null && executionRecord.snapshotId() >= 0L;
    }

    private MinimizedJobInfoDTO toMinimizedJobInfo(JetClusterMetricsStore store, JobAndSqlSummary summary) {
        String id = Util.idToString((long)summary.getJobId());
        MinimizedJobInfoDTO.MinimizedJobInfoDTOBuilder builder = MinimizedJobInfoDTO.builder().id(id).name(summary.getNameOrId()).status(summary.getStatus()).submissionTime(summary.getSubmissionTime()).completionTime(summary.getCompletionTime()).failure(summary.getFailureText()).userCancelled(summary.isUserCancelled());
        if (this.isSuspended(summary.getStatus())) {
            builder.suspensionCause(summary.getSuspensionCause());
        }
        if (this.isActive(summary)) {
            builder.totalIn(this.getTotalIn(store, id)).totalOut(this.getTotalOut(store, id));
        }
        return builder.build();
    }

    @VisibleForTesting
    long getTotalIn(JetClusterMetricsStore store, String id) {
        return store.query("emittedCount", (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)id), TagExpressions.tagNotEquals((String)"ordinal", (String)"snapshot"), TagExpressions.tagEquals((String)"source", (String)"true")})).mapToLong(TimeSeries::queryLast).sum();
    }

    private long getTotalOut(JetClusterMetricsStore store, String id) {
        return store.query("receivedCount", (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)id), TagExpressions.tagEquals((String)"sink", (String)"true")})).mapToLong(TimeSeries::queryLast).sum();
    }

    private boolean isActive(JobAndSqlSummary jobSummary) {
        JobStatus status = jobSummary.getStatus();
        return this.isActive(status);
    }

    private boolean isActive(Job job) {
        JobStatus status = job.getStatus();
        return this.isActive(status);
    }

    private boolean isActive(JobStatus status) {
        return status == JobStatus.RUNNING || status == JobStatus.SUSPENDED || status == JobStatus.SUSPENDED_EXPORTING_SNAPSHOT;
    }

    private boolean isSuspended(JobStatus status) {
        return status == JobStatus.SUSPENDED || status == JobStatus.SUSPENDED_EXPORTING_SNAPSHOT;
    }

    private static long findFirstNonzero(long[] l) {
        for (long a : l) {
            if (a == 0L) continue;
            return a;
        }
        return 0L;
    }
}

