/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.MemberMetricsSupplier;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataPoolAwareAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Map;

class OsMetricsAvailabilityAnalyzer
extends SourceDataPoolAwareAnalyzer {
    private static final String JVM_ARGS_ADVICE = "If the member runs on Java 9+ the startup flag `--add-opens jdk.management/com.sun.management.internal=ALL-UNNAMED` is required to read OS metrics";
    private final MemberMetricsSupplier memberMetricsSupplier;

    OsMetricsAvailabilityAnalyzer(SourceDataSubscriptionPool poolDelegate) {
        super(poolDelegate);
        this.memberMetricsSupplier = poolDelegate.subscribeToMetric("os.freePhysicalMemorySize");
    }

    @Nonnull
    public AnalysisOutcome doAnalyzeInternal(SourceDataFilter filter, IgnoreList ignoreList) {
        ArrayList problems = new ArrayList();
        filter.filter((Map)this.memberMetricsSupplier.get()).forEach((memberIdentifier, metricValue) -> {
            if (metricValue == null || metricValue.isEmpty()) {
                problems.add(new MemberProblem("Can't read the member operating system metrics", JVM_ARGS_ADVICE, Problem.ProblemType.FAIL, memberIdentifier));
            }
        });
        return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), problems);
    }

    public String describeSelf() {
        return "Checking if member OS metrics are available";
    }

    String getCheckId() {
        return AnalyzerCheckId.OS_METRICS_AVAILABILITY_ANALYZER.getCheckId();
    }
}

