/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SemanticConfigAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class MapNativeMemoryEvictionAnalyzer
extends SemanticConfigAnalyzer {
    private static final Set<MaxSizePolicy> INVALID_MAX_SIZE_POLICIES = EnumSet.of(MaxSizePolicy.FREE_HEAP_PERCENTAGE, MaxSizePolicy.FREE_HEAP_SIZE, MaxSizePolicy.USED_HEAP_PERCENTAGE, MaxSizePolicy.USED_HEAP_SIZE);

    MapNativeMemoryEvictionAnalyzer(SourceDataSubscriptionPool pool) {
        super(pool);
    }

    protected List<Problem> doAnalyzeInternal(MemberConfig config, List<String> disabledDataStructures) {
        return config.toEffectiveConfig().getMapConfigs().values().stream().filter(mapConfig -> !disabledDataStructures.contains(mapConfig.getName())).map(MapNativeMemoryEvictionAnalyzer::identifyProblem).flatMap(Optional::stream).collect(Collectors.toList());
    }

    private static Optional<Problem> identifyProblem(MapConfig mapConfig) {
        if (mapConfig.getInMemoryFormat() != InMemoryFormat.NATIVE) {
            return Optional.empty();
        }
        EvictionConfig eviction = mapConfig.getEvictionConfig();
        if (eviction != null && INVALID_MAX_SIZE_POLICIES.contains(eviction.getMaxSizePolicy())) {
            return Optional.of(new ClusterWideProblem("NATIVE in-memory format does not work with eviction maximum size policy FREE_HEAP_PERCENTAGE as configured in " + mapConfig.getName(), "Choose an other in-memory format, or use one of the following maximum size policies: USED_NATIVE_MEMORY_SIZE, USED_NATIVE_MEMORY_PERCENTAGE, FREE_NATIVE_MEMORY_SIZE, FREE_NATIVE_MEMORY_PERCENTAGE, PER_NODE, PER_PARTITION, ENTRY_COUNT", Problem.ProblemType.FAIL, mapConfig.getName()));
        }
        return Optional.empty();
    }

    public String describeSelf() {
        return "Checking if Map configs with native memory have proper eviction configurations";
    }

    String getCheckId() {
        return AnalyzerCheckId.MAP_NATIVE_MEMORY_EVICTION_ANALYZER.getCheckId();
    }
}

