/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.AttributeComparisonDispatcher;
import com.hazelcast.webmonitor.service.healthcheck.CPSubsystemAttributeEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.EqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CPSubsystemConfigEqualityAnalyzer
extends EqualityAnalyzer {
    CPSubsystemConfigEqualityAnalyzer(SourceDataSubscriptionPool poolDelegate) {
        super(poolDelegate);
    }

    String getCheckId() {
        return AnalyzerCheckId.CP_SUBSYSTEM_ATTRIBUTE_EQUALITY_ANALYZER.getCheckId();
    }

    String describeSelf() {
        return "Checking if CP Subsystem is configured the same way across members";
    }

    protected List<Problem> identifyProblems(Map<MemberIdentifier, Config> effectiveConfigs) {
        Map<MemberIdentifier, Config> cpMemberConfigs = effectiveConfigs.entrySet().stream().filter(entry -> ((Config)entry.getValue()).getCPSubsystemConfig().getCPMemberCount() != 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return AttributeComparisonDispatcher.dispatch((Map)this.extractConfigAttribute(cpMemberConfigs, Config::getCPSubsystemConfig), CPSubsystemAttributeEquivalence::new);
    }
}

