/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hazelcast.webmonitor.service.healthcheck.HealthcheckStatus;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.VersionRestriction;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class AnalysisOutcome {
    String checkId;
    String analysisDescription;
    @JsonProperty(value="isDisabledClusterWide")
    boolean isDisabledClusterWide;
    VersionRestriction versionRestriction;
    List<String> disabledDataStructures;
    List<Problem> problems;

    static AnalysisOutcome disabledClusterWide(String checkId, String analysisDescription) {
        return new AnalysisOutcome(checkId, analysisDescription, true, Collections.emptyList(), Collections.emptyList());
    }

    static AnalysisOutcome withMinRequiredVersion(String checkId, String analysisDescription, VersionRestriction versionRestriction) {
        AnalysisOutcome outcome = new AnalysisOutcome(checkId, analysisDescription, false, Collections.emptyList(), Collections.emptyList());
        outcome.setVersionRestriction(versionRestriction);
        return outcome;
    }

    static AnalysisOutcome withDisabledDataStructures(String checkId, String analysisDescription, List<String> disabledDataStructures, List<Problem> problems) {
        return new AnalysisOutcome(checkId, analysisDescription, false, disabledDataStructures, problems);
    }

    static AnalysisOutcome noProblem(String checkId, String analysisDescription) {
        return new AnalysisOutcome(checkId, analysisDescription, false, Collections.emptyList(), Collections.emptyList());
    }

    static AnalysisOutcome withProblems(String checkId, String analysisDescription, List<Problem> problems) {
        return new AnalysisOutcome(checkId, analysisDescription, false, Collections.emptyList(), problems);
    }

    private AnalysisOutcome(String checkId, String analysisDescription, boolean isDisabledClusterWide, List<String> disabledDataStructures, List<Problem> problems) {
        this.checkId = checkId;
        this.analysisDescription = analysisDescription;
        this.isDisabledClusterWide = isDisabledClusterWide;
        this.disabledDataStructures = disabledDataStructures;
        this.problems = problems.stream().sorted(Comparator.comparing(Problem::getDescription)).toList();
    }

    @JsonIgnore
    public boolean isSuccessful() {
        return this.problems.isEmpty() || this.problems.stream().allMatch(problem -> problem.getType() == Problem.ProblemType.INFO);
    }

    @JsonIgnore
    public List<Problem> getFails() {
        return this.problems.stream().filter(problem -> problem.getType().equals((Object)Problem.ProblemType.FAIL)).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<Problem> getWarnings() {
        return this.problems.stream().filter(problem -> problem.getType().equals((Object)Problem.ProblemType.WARNING)).collect(Collectors.toList());
    }

    @JsonIgnore
    public boolean getIsDisabledClusterWide() {
        return this.isDisabledClusterWide;
    }

    @JsonIgnore
    public Stream<HealthcheckStatus> streamStatuses() {
        boolean hasDisabledDataStructures;
        if (this.versionRestriction != null) {
            return Stream.of(HealthcheckStatus.NA);
        }
        if (this.isDisabledClusterWide) {
            return Stream.of(HealthcheckStatus.DISABLED);
        }
        boolean bl = hasDisabledDataStructures = !this.disabledDataStructures.isEmpty();
        if (this.problems.isEmpty() && !hasDisabledDataStructures) {
            return Stream.of(HealthcheckStatus.PASS);
        }
        Stream<HealthcheckStatus> statusesStreamFromProblems = this.problems.stream().map(problem -> HealthcheckStatus.fromProblemType((Problem.ProblemType)problem.type)).distinct();
        if (hasDisabledDataStructures) {
            return Stream.concat(statusesStreamFromProblems, Stream.of(HealthcheckStatus.DISABLED));
        }
        return statusesStreamFromProblems;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCheckId() {
        return this.checkId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAnalysisDescription() {
        return this.analysisDescription;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public VersionRestriction getVersionRestriction() {
        return this.versionRestriction;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getDisabledDataStructures() {
        return this.disabledDataStructures;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Problem> getProblems() {
        return this.problems;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAnalysisDescription(String analysisDescription) {
        this.analysisDescription = analysisDescription;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDisabledClusterWide(boolean isDisabledClusterWide) {
        this.isDisabledClusterWide = isDisabledClusterWide;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setVersionRestriction(VersionRestriction versionRestriction) {
        this.versionRestriction = versionRestriction;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDisabledDataStructures(List<String> disabledDataStructures) {
        this.disabledDataStructures = disabledDataStructures;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setProblems(List<Problem> problems) {
        this.problems = problems;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalysisOutcome)) {
            return false;
        }
        AnalysisOutcome other = (AnalysisOutcome)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getIsDisabledClusterWide() != other.getIsDisabledClusterWide()) {
            return false;
        }
        String this$checkId = this.getCheckId();
        String other$checkId = other.getCheckId();
        if (this$checkId == null ? other$checkId != null : !this$checkId.equals(other$checkId)) {
            return false;
        }
        String this$analysisDescription = this.getAnalysisDescription();
        String other$analysisDescription = other.getAnalysisDescription();
        if (this$analysisDescription == null ? other$analysisDescription != null : !this$analysisDescription.equals(other$analysisDescription)) {
            return false;
        }
        VersionRestriction this$versionRestriction = this.getVersionRestriction();
        VersionRestriction other$versionRestriction = other.getVersionRestriction();
        if (this$versionRestriction == null ? other$versionRestriction != null : !this$versionRestriction.equals(other$versionRestriction)) {
            return false;
        }
        List this$disabledDataStructures = this.getDisabledDataStructures();
        List other$disabledDataStructures = other.getDisabledDataStructures();
        if (this$disabledDataStructures == null ? other$disabledDataStructures != null : !((Object)this$disabledDataStructures).equals(other$disabledDataStructures)) {
            return false;
        }
        List this$problems = this.getProblems();
        List other$problems = other.getProblems();
        return !(this$problems == null ? other$problems != null : !((Object)this$problems).equals(other$problems));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnalysisOutcome;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.getIsDisabledClusterWide() ? 79 : 97);
        String $checkId = this.getCheckId();
        result = result * 59 + ($checkId == null ? 43 : $checkId.hashCode());
        String $analysisDescription = this.getAnalysisDescription();
        result = result * 59 + ($analysisDescription == null ? 43 : $analysisDescription.hashCode());
        VersionRestriction $versionRestriction = this.getVersionRestriction();
        result = result * 59 + ($versionRestriction == null ? 43 : $versionRestriction.hashCode());
        List $disabledDataStructures = this.getDisabledDataStructures();
        result = result * 59 + ($disabledDataStructures == null ? 43 : ((Object)$disabledDataStructures).hashCode());
        List $problems = this.getProblems();
        result = result * 59 + ($problems == null ? 43 : ((Object)$problems).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "AnalysisOutcome(checkId=" + this.getCheckId() + ", analysisDescription=" + this.getAnalysisDescription() + ", isDisabledClusterWide=" + this.getIsDisabledClusterWide() + ", versionRestriction=" + String.valueOf(this.getVersionRestriction()) + ", disabledDataStructures=" + String.valueOf(this.getDisabledDataStructures()) + ", problems=" + String.valueOf(this.getProblems()) + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AnalysisOutcome() {
    }
}

