/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.dynamicconfig;

import com.hazelcast.config.Config;
import com.hazelcast.internal.config.ConfigNamespace;
import com.hazelcast.internal.config.ConfigSections;
import com.hazelcast.internal.dynamicconfig.ConfigUpdateResult;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;

public final class ConfigPatch {
    private static final Map<ConfigSections, Function<Config, Map<String, ?>>> SECTIONS_TO_MAP_GETTERS = new EnumMap(Map.ofEntries(Map.entry(ConfigSections.MAP, Config::getMapConfigs), Map.entry(ConfigSections.QUEUE, Config::getQueueConfigs), Map.entry(ConfigSections.CACHE, Config::getCacheConfigs), Map.entry(ConfigSections.LIST, Config::getListConfigs), Map.entry(ConfigSections.SET, Config::getSetConfigs), Map.entry(ConfigSections.MULTIMAP, Config::getMultiMapConfigs), Map.entry(ConfigSections.REPLICATED_MAP, Config::getReplicatedMapConfigs), Map.entry(ConfigSections.RINGBUFFER, Config::getRingbufferConfigs), Map.entry(ConfigSections.TOPIC, Config::getTopicConfigs), Map.entry(ConfigSections.RELIABLE_TOPIC, Config::getReliableTopicConfigs), Map.entry(ConfigSections.EXECUTOR_SERVICE, Config::getExecutorConfigs), Map.entry(ConfigSections.DURABLE_EXECUTOR_SERVICE, Config::getDurableExecutorConfigs), Map.entry(ConfigSections.SCHEDULED_EXECUTOR_SERVICE, Config::getScheduledExecutorConfigs), Map.entry(ConfigSections.CARDINALITY_ESTIMATOR, Config::getCardinalityEstimatorConfigs), Map.entry(ConfigSections.PN_COUNTER, Config::getPNCounterConfigs), Map.entry(ConfigSections.FLAKE_ID_GENERATOR, Config::getFlakeIdGeneratorConfigs), Map.entry(ConfigSections.WAN_REPLICATION, Config::getWanReplicationConfigs)));
    private final String text;

    public static ConfigPatch ofText(String text) {
        return new ConfigPatch(text);
    }

    public ConfigPatch(String text) {
        this.text = text;
    }

    public Config toEffectiveConfig() {
        return Config.loadFromString((String)this.text);
    }

    public ConfigUpdateResult previewOn(MemberConfig originalConfig) {
        Config effective = originalConfig.toEffectiveConfig();
        Config patch = this.toEffectiveConfig();
        HashSet<ConfigNamespace> addedConfigs = new HashSet<ConfigNamespace>();
        HashSet ignoredConfigs = new HashSet();
        SECTIONS_TO_MAP_GETTERS.forEach((section, mapGetter) -> ((Map)mapGetter.apply(patch)).forEach((addedSectionName, addedConfig) -> {
            Set targetSet = ((Map)mapGetter.apply(effective)).containsKey(addedSectionName) ? ignoredConfigs : addedConfigs;
            targetSet.add(new ConfigNamespace(section, addedSectionName));
        }));
        if (patch.getLicenseKey() != null) {
            addedConfigs.add(new ConfigNamespace(ConfigSections.LICENSE_KEY));
        }
        return new ConfigUpdateResult(addedConfigs, ignoredConfigs);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getText() {
        return this.text;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigPatch)) {
            return false;
        }
        ConfigPatch other = (ConfigPatch)o;
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ConfigPatch(text=" + this.getText() + ")";
    }
}

