/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.cluster.Member;
import com.hazelcast.webmonitor.controller.dto.SlowOperationDTO;
import com.hazelcast.webmonitor.controller.dto.SlowOperationInvocationDTO;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.controller.exception.OperationFailedApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.model.hz.req.state.ClusterState;
import com.hazelcast.webmonitor.model.hz.req.state.LicenseDTO;
import com.hazelcast.webmonitor.model.hz.req.state.LocalOperationStats;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.model.hz.req.state.NodeState;
import com.hazelcast.webmonitor.service.DisconnectedFromClusterEvent;
import com.hazelcast.webmonitor.service.MemberRemovedEvent;
import com.hazelcast.webmonitor.utils.MemberUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class StateManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StateManager.class);
    static final int INTERVAL_MSEC = 10000;
    private static final int LATEST_STATE_TTL_SEC = 120;
    private final Cache<String, AllState> latestStateCache = Caffeine.newBuilder().expireAfterWrite(120L, TimeUnit.SECONDS).build();

    @EventListener
    public void removeMemberFromAllState(MemberRemovedEvent event) {
        String memberAddress = MemberUtil.getMemberAddress((Member)event.getRemovedMember());
        this.latestStateCache.asMap().computeIfPresent(event.getCluster(), (k, v) -> {
            v.removeMemberState(memberAddress);
            return v;
        });
    }

    @EventListener
    public void invalidateClusterState(DisconnectedFromClusterEvent event) {
        this.latestStateCache.asMap().remove(event.getCluster());
    }

    public Set<String> getClusterNames() {
        return this.latestStateCache.asMap().keySet();
    }

    public void cacheLatestState(String cluster, AllState state) {
        this.latestStateCache.put((Object)cluster, (Object)state);
    }

    @Nullable
    public AllState getLatestState(String cluster) {
        return (AllState)this.latestStateCache.getIfPresent((Object)cluster);
    }

    public boolean isStateAvailable(String cluster) {
        return this.latestStateCache.getIfPresent((Object)cluster) != null;
    }

    @Nullable
    public ClusterState getClusterState(String cluster) {
        AllState latestState = this.getLatestState(cluster);
        if (latestState == null) {
            return null;
        }
        return latestState.getRandomMemberState().map(MemberState::getNodeState).map(NodeState::getClusterState).orElse(null);
    }

    public AllState getLatestStateIfSameInterval(String cluster, long now) {
        AllState state = (AllState)this.latestStateCache.getIfPresent((Object)cluster);
        if (state != null && Math.abs(now - state.getTime()) < 10000L) {
            return state;
        }
        return null;
    }

    public static long floorTimeToInterval(long now) {
        return now - now % 10000L;
    }

    public SortedSet<String> getInstanceNames(InstanceType type, String cluster) {
        AllState state = this.getLatestState(cluster);
        return state == null ? Collections.emptySortedSet() : state.getInstanceNames(type);
    }

    public List<SlowOperationDTO> getSlowOperationsList(String cluster, String member) {
        AllState state = this.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyList();
        }
        ArrayList<SlowOperationDTO> result = new ArrayList<SlowOperationDTO>();
        MemberState memberState = (MemberState)state.getMemberStates().get(member);
        if (memberState != null) {
            LocalOperationStats localOperations = memberState.getOperationStats();
            List<SlowOperationDTO> dtos = localOperations.getSlowOperations().stream().map(dto -> SlowOperationDTO.builder().operation(dto.getOperation()).stackTrace(dto.getStackTrace()).invocations(dto.getInvocations().stream().map(item -> SlowOperationInvocationDTO.builder().id(item.getId()).details(item.getDetails()).startedAt(item.getStartedAt()).durationMs(item.getDurationMs()).build()).toList()).totalInvocations(dto.getTotalInvocations()).build()).toList();
            result.addAll(dtos);
        }
        return result;
    }

    public Map<String, ClientEndPointDTO> getClients(String cluster) {
        AllState state = this.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyMap();
        }
        return state.getClientsPerUuid();
    }

    public Map<String, ClientEndPointDTO> getStatsEnabledClients(String cluster) {
        AllState state = this.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyMap();
        }
        return state.getStatsEnabledClients();
    }

    public void verifyDataAccessEnabled(String cluster) {
        AllState state = this.getLatestState(cluster);
        if (state != null && !state.isDataAccessEnabled()) {
            throw new OperationFailedApiException("Management Center Data Access is disabled in member config.");
        }
    }

    public Optional<LicenseDTO> getClusterLicense(String cluster) throws OperationFailedApiException {
        AllState state = this.getLatestState(cluster);
        if (state == null) {
            throw new NoClusterApiException(cluster);
        }
        return state.getMemberStates().stream().map(MemberState::getNodeState).map(NodeState::getLicenseDTO).filter(Objects::nonNull).findFirst();
    }
}

