/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.cloud;

import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.security.cloud.CloudOidcUserService;
import com.hazelcast.webmonitor.security.cloud.CloudSecurityConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenValidator;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@Profile(value={"hzcloud"})
public class CloudSecurityConfig {
    static final String CSP_HEADER_VALUE_FORMAT = "script-src 'self' 'unsafe-inline' 'unsafe-eval' app.pendo.io pendo-io-static.storage.googleapis.com cdn.pendo.io pendo-static-6720724486979584.storage.googleapis.com data.pendo.io; style-src 'unsafe-inline' app.pendo.io cdn.pendo.io pendo-static-6720724486979584.storage.googleapis.com; img-src 'self' data: cdn.pendo.io app.pendo.io pendo-static-6720724486979584.storage.googleapis.com data.pendo.io; connect-src 'self' app.pendo.io data.pendo.io pendo-static-6720724486979584.storage.googleapis.com; frame-ancestors app.pendo.io 'self' https://*.hazelcast.com https://*.hazelcast.cloud http://localhost:* https://localhost:* %s; frame-src app.pendo.io; child-src app.pendo.io";
    private final MCConfigurationProperties mcProperties;

    @Bean
    WebSecurityCustomizer httpFireWallWebSecurityCustomizer() {
        return web -> {
            StrictHttpFirewall firewall = new StrictHttpFirewall();
            firewall.setAllowedHttpMethods(Set.of(HttpMethod.GET.name(), HttpMethod.POST.name(), HttpMethod.DELETE.name(), HttpMethod.OPTIONS.name()));
            firewall.setAllowUrlEncodedSlash(true);
            web.httpFirewall((HttpFirewall)firewall);
        };
    }

    @Bean
    @Order(value=1)
    SecurityFilterChain oauth2(HttpSecurity http) throws Exception {
        return (SecurityFilterChain)http.securityMatcher(new String[]{"/api/**", "/rest/**", "/metrics"}).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/api/swagger-ui/config"})).permitAll().anyRequest()).authenticated()).oauth2ResourceServer(oauth2 -> oauth2.jwt(jwt -> jwt.jwtAuthenticationConverter(source -> new ServiceTokenCustomizer().convert(source)))).csrf(AbstractHttpConfigurer::disable).cors(Customizer.withDefaults()).build();
    }

    @Bean
    @Order(value=2)
    SecurityFilterChain oidc(HttpSecurity http, ClientRegistrationRepository clientRegistrationRepository) throws Exception {
        OidcClientInitiatedLogoutSuccessHandler logoutSuccessHandler = new OidcClientInitiatedLogoutSuccessHandler(clientRegistrationRepository);
        logoutSuccessHandler.setPostLogoutRedirectUri("{baseUrl}");
        return (SecurityFilterChain)http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/api/swagger-ui/config", "/error.html"})).permitAll().anyRequest()).authenticated()).cors(Customizer.withDefaults()).oauth2Login(oidc -> oidc.userInfoEndpoint(userInfoEndpoint -> userInfoEndpoint.oidcUserService((OAuth2UserService)new CloudOidcUserService()))).logout(logout -> logout.logoutSuccessHandler((LogoutSuccessHandler)logoutSuccessHandler)).headers(headers -> headers.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable).contentSecurityPolicy(config -> config.policyDirectives(CSP_HEADER_VALUE_FORMAT.formatted(StringUtils.defaultString((String)this.mcProperties.getInternal().getCloudAddress()))))).build();
    }

    @Bean
    UrlBasedCorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOriginPatterns(List.of("*"));
        configuration.setAllowedMethods(List.of("GET"));
        configuration.setAllowedHeaders(List.of("Authorization"));
        UrlBasedCorsConfigurationSource configurationSource = new UrlBasedCorsConfigurationSource();
        configurationSource.registerCorsConfiguration("/**", configuration);
        return configurationSource;
    }

    @Bean
    JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        OidcIdTokenDecoderFactory idTokenDecoderFactory = new OidcIdTokenDecoderFactory();
        idTokenDecoderFactory.setJwtValidatorFactory(clientRegistration -> new DelegatingOAuth2TokenValidator(new OAuth2TokenValidator[]{new JwtTimestampValidator(), new OidcIdTokenValidator(clientRegistration), new CloudClaimsValidator(this.mcProperties)}));
        return idTokenDecoderFactory;
    }

    static boolean hasCloudAdminRole(Jwt token) {
        Map hzcClaims = token.getClaimAsMap("hzc");
        if (hzcClaims != null) {
            List roles = (List)hzcClaims.get("roles");
            return roles != null && roles.contains("CLOUD_ADMIN");
        }
        return false;
    }

    @ConstructorProperties(value={"mcProperties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CloudSecurityConfig(MCConfigurationProperties mcProperties) {
        this.mcProperties = mcProperties;
    }
}

