/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security;

import com.hazelcast.webmonitor.controller.dto.security.AuthTokenDTO;
import com.hazelcast.webmonitor.security.spi.impl.builtin.TokenBasedAuthenticationToken;
import com.hazelcast.webmonitor.service.AuthTokenManager;
import com.hazelcast.webmonitor.utils.SecurityContextUtil;
import com.hazelcast.webmonitor.utils.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class BearerTokenAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BearerTokenAuthenticationFilter.class);
    private final AuthTokenManager authTokenManager;

    public BearerTokenAuthenticationFilter(String requiresAuth, AuthTokenManager authTokenManager) {
        super(requiresAuth);
        this.authTokenManager = authTokenManager;
    }

    public Authentication attemptAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws AuthenticationException {
        Authentication currentAuth = SecurityContextUtil.getAuthentication();
        if (currentAuth != null) {
            return currentAuth;
        }
        String bearerToken = this.getBearerToken(httpServletRequest);
        try {
            AuthTokenDTO authTokenDTO = (AuthTokenDTO)this.authTokenManager.find(bearerToken).orElseThrow(() -> new BadCredentialsException("Invalid token."));
            String username = authTokenDTO.getUsername();
            if (authTokenDTO.getRoles() != null) {
                List authorities = Arrays.stream(authTokenDTO.getRoles().split(",")).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
                return new UsernamePasswordAuthenticationToken((Object)username, null, authorities);
            }
            TokenBasedAuthenticationToken authRequest = new TokenBasedAuthenticationToken(username, bearerToken);
            return this.getAuthenticationManager().authenticate((Authentication)authRequest);
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Token authentication failed: could not read token data", (Throwable)e);
            throw new AuthenticationServiceException("Token authentication failed", (Throwable)e);
        }
    }

    private String getBearerToken(HttpServletRequest httpServletRequest) {
        String bearerToken;
        String[] parts;
        String authHeader = httpServletRequest.getHeader("Authorization");
        if (authHeader != null && authHeader.startsWith("Bearer ") && (parts = authHeader.split(" ")).length == 2 && !StringUtil.isNullOrEmptyAfterTrim((String)(bearerToken = parts[1]))) {
            return bearerToken;
        }
        throw new BadCredentialsException("No bearer token provided.");
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        SecurityContextUtil.setAuthentication((Authentication)authResult);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

