/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.UserModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.Optional;
import lombok.Generated;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

@Repository
public class UserDAO {
    private final Jdbi jdbi;

    public void updateLoginTime(String username, OffsetDateTime timestamp) {
        this.jdbi.useHandle(handle -> {
            UserModel user = this.getUserTx(handle, username).orElseGet(() -> this.insertTx(handle, username));
            user.setLastLoginTime(user.getCurrentLoginTime());
            user.setCurrentLoginTime(timestamp);
            try (Update update = handle.createUpdate("update users set last_login_time = :lastLoginTime, current_login_time = :currentLoginTime where username = :username");){
                ((Update)((Update)((Update)update.bind("lastLoginTime", (Object)user.getLastLoginTime())).bind("currentLoginTime", (Object)user.getCurrentLoginTime())).bind("username", user.getUsername())).execute();
            }
        });
    }

    private Optional<UserModel> getUserTx(Handle handle, String username) {
        try (Query query = handle.createQuery("select username, last_login_time, current_login_time from users where username = :username");){
            Optional optional = ((Query)query.bind("username", username)).mapToBean(UserModel.class).findFirst();
            return optional;
        }
    }

    public UserModel insert(String username) {
        return (UserModel)this.jdbi.withHandle(handle -> this.insertTx(handle, username));
    }

    public UserModel insertTx(Handle handle, String username) {
        UserModel newUser = new UserModel();
        newUser.setUsername(username);
        try (Update update = handle.createUpdate("insert into users (username, last_login_time, current_login_time) values (:username, :lastLoginTime, :currentLoginTime)");){
            ((Update)update.bindBean((Object)newUser)).execute();
        }
        return newUser;
    }

    public Optional<OffsetDateTime> getLastLoginTime(String username) {
        return ((Optional)this.jdbi.withHandle(handle -> this.getUserTx(handle, username))).map(UserModel::getLastLoginTime);
    }

    public void deleteTx(Handle handle, String username) {
        try (Update update = handle.createUpdate("delete from users where username = :username");){
            ((Update)update.bind("username", username)).execute();
        }
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UserDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

