/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.inmemory;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.impl.AbstractMetricsStorage;
import com.hazelcast.webmonitor.metrics.impl.inmemory.ClusterMetricsStore;
import com.hazelcast.webmonitor.metrics.jet.TimeSeriesSlice;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.AndExpression;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpression;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpressions;
import com.hazelcast.webmonitor.metrics.jet.tsdb.TimeSeries;
import com.hazelcast.webmonitor.metrics.jet.tsdb.TimeSeriesImpl;
import com.hazelcast.webmonitor.metrics.utils.DataPointSeriesBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryMetricsStorage
extends AbstractMetricsStorage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryMetricsStorage.class);
    private static final int METRICS_STORE_EXPIRE_AFTER_ACCESS_DURATION = 30;
    private static final int FIVE_MINUTES = 300;
    public static final long SECOND_IN_MS = TimeUnit.SECONDS.toMillis(1L);
    private final ScheduledExecutorService danglingMetricsGC = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "DanglingMetricsGC"));
    private final LoadingCache<String, ClusterMetricsStore> stores = Caffeine.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build(key -> new ClusterMetricsStore(300));

    public InMemoryMetricsStorage() {
        this.danglingMetricsGC.scheduleAtFixedRate(() -> this.cleanUpDanglingMetrics(), 300L, 300L, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    void cleanUpDanglingMetrics() {
        this.stores.asMap().values().forEach(ClusterMetricsStore::cleanUpDanglingEntries);
    }

    public int getRetentionSeconds() {
        return 300;
    }

    protected void doStore(@Nonnull String cluster, @Nonnull List<MetricDataPoint> dataPoints) {
        this.getStore(cluster).storeMetricsCollection(dataPoints);
    }

    protected DataPointSeries doQueryRange(@Nonnull Query query) {
        AndExpression filter = TagExpressions.and((Collection)query.getTags().entrySet().stream().map(tag -> TagExpressions.tagEquals((String)((Tag)tag.getKey()).getName(), (String)((String)tag.getValue()))).collect(Collectors.toList()));
        TimeSeries timeSeries = this.getStore(query.getCluster()).querySingle(query.getMetric(), (TagExpression)filter);
        if (timeSeries == TimeSeriesImpl.EMPTY_TIMESERIES) {
            return DataPointSeries.empty();
        }
        long truncatedStartMs = query.getStart() / SECOND_IN_MS * SECOND_IN_MS;
        long truncatedEndMs = query.getEnd() / SECOND_IN_MS * SECOND_IN_MS;
        TimeSeriesSlice slice = timeSeries.queryRange(truncatedStartMs, truncatedEndMs + SECOND_IN_MS, Long.MIN_VALUE);
        long rangeEnd = slice.getStartTs() + (long)slice.size() * slice.getInterval();
        DataPointSeriesBuilder builder = new DataPointSeriesBuilder(slice.getStartTs(), rangeEnd, query.getMetric().getType());
        long[] times = new long[slice.size()];
        long value = truncatedStartMs;
        for (int i = 0; i < slice.size(); ++i) {
            times[i] = value;
            value += slice.getInterval();
        }
        return builder.append(times, slice.getSeries()).build();
    }

    protected Optional<DataPointAware> doQueryLatest(@Nonnull Query query) {
        return this.doQueryRange(query).getLatestDataPoint();
    }

    protected Set<String> doGetMonitoredClusters() {
        return this.stores.asMap().keySet();
    }

    protected long doCountStoredDataPoints(@Nonnull String cluster) {
        return this.getStore(cluster).all().mapToInt(TimeSeries::size).sum();
    }

    protected void doClose() {
        this.stores.invalidateAll();
    }

    public ClusterMetricsStore getStore(String cluster) {
        return (ClusterMetricsStore)this.stores.get((Object)cluster);
    }

    public void truncate(String cluster) {
        this.stores.invalidate((Object)cluster);
    }

    public boolean supportsTimeTravel() {
        return false;
    }

    public long calculateDiskSize() {
        return 0L;
    }
}

